/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;

@SerializeWith(value=Externalizer.class)
public class RemoveAtIndexOperation
extends ArrayOperation {
    protected final int index;
    protected transient Object actualValue = null;

    public RemoveAtIndexOperation(Path path, int index) {
        super(path);
        this.index = index;
    }

    @Override
    public RemoveAtIndexOperation clone() {
        return new RemoveAtIndexOperation(this.getParentPath(), this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public Object getRemovedValue() {
        return this.actualValue;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.actualValue != null) {
            MutableArray array = this.mutableParent(delegate);
            array.add(this.index, this.actualValue);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.actualValue = array.remove(this.index);
    }

    public String toString() {
        return "Remove at '" + this.parentPath + "' the value at index " + this.index;
    }

    public static final class Externalizer
    extends SchematicExternalizer<RemoveAtIndexOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, RemoveAtIndexOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.index);
        }

        public RemoveAtIndexOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            int index = input.readInt();
            return new RemoveAtIndexOperation(path, index);
        }

        @Override
        public Integer getId() {
            return 1608;
        }

        @Override
        public Set<Class<? extends RemoveAtIndexOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RemoveAtIndexOperation.class});
        }
    }
}

