/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrSharedNodeCache;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

@ThreadSafe
final class JcrSharedNode
extends JcrNode {
    private final NodeKey parentKey;
    private final JcrSharedNodeCache.SharedSet sharedSet;

    protected JcrSharedNode(JcrSharedNodeCache.SharedSet sharedSet, NodeKey parentKey) {
        super(sharedSet.session(), sharedSet.key());
        this.parentKey = parentKey;
        this.sharedSet = sharedSet;
        assert (this.parentKey != null);
        assert (this.sharedSet != null);
    }

    @Override
    boolean isShared() {
        return true;
    }

    @Override
    protected NodeKey parentKey() {
        return this.parentKey;
    }

    @Override
    protected void doRemove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.sharedSet.remove(this);
        SessionCache cache = this.sessionCache();
        NodeKey key = this.key();
        MutableCachedNode parent = this.mutableParent();
        parent.removeChild(cache, key);
    }

    @Override
    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        this.checkSession();
        return this.parent();
    }

    protected AbstractJcrNode parent() throws ItemNotFoundException {
        return this.session().node(this.parentKey, null);
    }

    @Override
    JcrSharedNodeCache.SharedSet sharedSet() {
        return this.sharedSet;
    }

    @Override
    Path path() throws ItemNotFoundException, InvalidItemStateException {
        AbstractJcrNode parent = this.parent();
        CachedNode node = parent.node();
        SessionCache cache = this.session.cache();
        ChildReference childRef = node.getChildReferences(cache).getChild(this.sharedSet.key());
        Path parentPath = parent.path();
        return this.session().pathFactory().create(parentPath, childRef.getSegment());
    }

    @Override
    protected Name name() throws RepositoryException {
        return this.segment().getName();
    }

    @Override
    protected Path.Segment segment() throws RepositoryException {
        AbstractJcrNode parent = this.parent();
        CachedNode node = parent.node();
        SessionCache cache = this.session.cache();
        ChildReference childRef = node.getChildReferences(cache).getChild(this.sharedSet.key());
        return childRef.getSegment();
    }
}

