/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.api.APINonTxTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class CacheAPITest
extends APINonTxTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = this.getDefaultStandaloneCacheConfig(true);
        cb.locking().isolationLevel(this.getIsolationLevel());
        this.addEviction(cb);
        this.amend(cb);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        cm.defineConfiguration("test", cb.build());
        this.cache = cm.getCache("test");
        return cm;
    }

    protected void amend(ConfigurationBuilder cb) {
    }

    protected abstract IsolationLevel getIsolationLevel();

    protected ConfigurationBuilder addEviction(ConfigurationBuilder cb) {
        return cb;
    }

    public void testConfiguration() {
        Configuration c = this.cache.getCacheConfiguration();
        assert (CacheMode.LOCAL.equals((Object)c.clustering().cacheMode()));
        assert (null != c.transaction().transactionManagerLookup());
    }

    public void testGetMembersInLocalMode() {
        assert (this.manager(this.cache).getAddress() == null) : "Cache members should be null if running in LOCAL mode";
    }

    public void testRollbackAfterOverwrite() throws Exception {
        String key = "key";
        String value = "value";
        String value2 = "value2";
        int size = 0;
        this.cache.put((Object)key, (Object)value);
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        TestingUtil.getTransactionManager(this.cache).begin();
        this.cache.put((Object)key, (Object)value2);
        assert (this.cache.get((Object)key).equals(value2));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value2));
        TestingUtil.getTransactionManager(this.cache).rollback();
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
    }

    public void testRollbackAfterRemove() throws Exception {
        String key = "key";
        String value = "value";
        int size = 0;
        this.cache.put((Object)key, (Object)value);
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        TestingUtil.getTransactionManager(this.cache).begin();
        this.cache.remove((Object)key);
        assert (this.cache.get((Object)key) == null);
        size = 0;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        TestingUtil.getTransactionManager(this.cache).rollback();
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
    }

    public void testRollbackAfterClear() throws Exception {
        String key = "key";
        String value = "value";
        int size = 0;
        this.cache.put((Object)key, (Object)value);
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        TransactionManager transactionManager = this.cache.getAdvancedCache().getTransactionManager();
        transactionManager.begin();
        this.log.trace((Object)("Here is where it begins: " + transactionManager.getTransaction()));
        this.cache.size();
        this.cache.clear();
        assert (this.cache.get((Object)key) == null);
        size = 0;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        TestingUtil.getTransactionManager(this.cache).rollback();
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntrySetEqualityInTx(Method m) throws Exception {
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        this.cache.putAll(dataIn);
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        try {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            HashMap<Integer, String> allEntriesIn = new HashMap<Integer, String>(dataIn);
            allEntriesIn.putAll(txDataIn);
            this.cache.putAll(txDataIn);
            Set entries = this.cache.entrySet();
            AssertJUnit.assertEquals(allEntriesIn.entrySet(), (Object)entries);
        }
        finally {
            tm.commit();
        }
    }

    public void testRollbackAfterPut() throws Exception {
        String key = "key";
        String value = "value";
        String key2 = "keyTwo";
        String value2 = "value2";
        int size = 0;
        this.cache.put((Object)key, (Object)value);
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        TestingUtil.getTransactionManager(this.cache).begin();
        this.cache.put((Object)key2, (Object)value2);
        assert (this.cache.get((Object)key2).equals(value2));
        assert (this.cache.keySet().contains(key2));
        size = 2;
        System.out.println(this.cache.size());
        assert (size == this.cache.size());
        assert (size == this.cache.keySet().size());
        assert (size == this.cache.values().size());
        assert (size == this.cache.entrySet().size());
        assert (this.cache.values().contains(value2));
        TestingUtil.getTransactionManager(this.cache).rollback();
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
    }

    public void testSizeAfterClear() {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)i, (Object)("value" + i));
        }
        this.cache.clear();
        assert (this.cache.isEmpty());
    }

    public void testPutIfAbsentAfterRemoveInTx() throws SystemException, NotSupportedException {
        String key = "key_1";
        String old_value = "old_value";
        this.cache.put((Object)key, (Object)old_value);
        assert (this.cache.get((Object)key).equals(old_value));
        TestingUtil.getTransactionManager(this.cache).begin();
        assert (this.cache.remove((Object)key).equals(old_value));
        assert (this.cache.get((Object)key) == null);
        TestingUtil.getTransactionManager(this.cache).rollback();
        AssertJUnit.assertEquals((Object)old_value, (Object)this.cache.get((Object)key));
    }
}

