/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class LockTestBase
extends AbstractInfinispanTest {
    private Log log = LogFactory.getLog(LockTestBase.class);
    protected boolean repeatableRead = true;
    protected boolean lockParentForChildInsertRemove = false;
    private CacheContainer cm;
    protected final ThreadLocal<LockTestBaseTL> threadLocal = new ThreadLocal();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        LockTestBaseTL tl = new LockTestBaseTL();
        Configuration defaultCfg = new Configuration();
        defaultCfg.setIsolationLevel(this.repeatableRead ? IsolationLevel.REPEATABLE_READ : IsolationLevel.READ_COMMITTED);
        defaultCfg.setLockAcquisitionTimeout(200L);
        defaultCfg.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.cm = TestCacheManagerFactory.createCacheManager(defaultCfg);
        tl.cache = this.cm.getCache();
        tl.lockManager = (LockManager)TestingUtil.extractComponentRegistry(tl.cache).getComponent(LockManager.class);
        tl.icc = (InvocationContextContainer)TestingUtil.extractComponentRegistry(tl.cache).getComponent(InvocationContextContainer.class);
        tl.tm = (TransactionManager)TestingUtil.extractComponentRegistry(tl.cache).getComponent(TransactionManager.class);
        this.threadLocal.set(tl);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        LockTestBaseTL tl = this.threadLocal.get();
        this.log.debug((Object)"**** - STARTING TEARDOWN - ****");
        TestingUtil.killCacheManagers(this.cm);
        this.threadLocal.set(null);
    }

    protected void assertLocked(Object key) {
        LockTestBaseTL tl = this.threadLocal.get();
        LockAssert.assertLocked(key, tl.lockManager, tl.icc);
    }

    protected void assertNotLocked(Object key) {
        LockTestBaseTL tl = this.threadLocal.get();
        LockAssert.assertNotLocked(key, tl.icc);
    }

    protected void assertNoLocks() {
        LockTestBaseTL tl = this.threadLocal.get();
        LockAssert.assertNoLocks(tl.lockManager, tl.icc);
    }

    public void testLocksOnPutKeyVal() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        DummyTransactionManager tm = (DummyTransactionManager)tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        assert (tm.getTransaction().runPrepare());
        this.assertLocked("k");
        tm.getTransaction().runCommitTx();
        tm.suspend();
        this.assertNoLocks();
        tm.begin();
        assert (((String)cache.get((Object)"k")).equals("v"));
        this.assertNotLocked("k");
        tm.commit();
        this.assertNoLocks();
        tm.begin();
        cache.remove((Object)"k");
        assert (tm.getTransaction().runPrepare());
        this.assertLocked("k");
        tm.getTransaction().runCommitTx();
        this.assertNoLocks();
    }

    public void testLocksOnPutData() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        tm.begin();
        cache.putAll(Collections.singletonMap("k", "v"));
        assert ("v".equals(cache.get((Object)"k")));
        DummyTransaction tx = ((DummyTransactionManager)tm).getTransaction();
        assert (tx.runPrepare());
        this.assertLocked("k");
        tx.runCommitTx();
        this.assertNoLocks();
        tm.suspend();
        tm.begin();
        assert ("v".equals(cache.get((Object)"k")));
        this.assertNoLocks();
        tm.commit();
        this.assertNoLocks();
    }

    public void testLocksOnEvict() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.putAll(Collections.singletonMap("k", "v"));
        assert ("v".equals(cache.get((Object)"k")));
        tm.begin();
        cache.evict((Object)"k");
        this.assertNotLocked("k");
        tm.commit();
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnRemoveNonexistent() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        DummyTransactionManager tm = (DummyTransactionManager)tl.tm;
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        tm.begin();
        cache.remove((Object)"k");
        tm.getTransaction().runPrepare();
        this.assertLocked("k");
        tm.getTransaction().runCommitTx();
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnEvictNonexistent() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        tm.begin();
        cache.evict((Object)"k");
        this.assertNotLocked("k");
        tm.commit();
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnRemoveData() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        DummyTransactionManager tm = (DummyTransactionManager)tl.tm;
        cache.put((Object)"k", (Object)"v");
        cache.put((Object)"k2", (Object)"v2");
        assert ("v".equals(cache.get((Object)"k")));
        assert ("v2".equals(cache.get((Object)"k2")));
        tm.begin();
        cache.clear();
        assert (tm.getTransaction().runPrepare());
        this.assertLocked("k");
        this.assertLocked("k2");
        tm.getTransaction().runCommitTx();
        assert (cache.isEmpty());
        this.assertNoLocks();
    }

    public void testWriteDoesntBlockRead() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        cache.put((Object)"k2", (Object)"v2");
        Transaction write = tm.suspend();
        tm.begin();
        assert ("v".equals(cache.get((Object)"k")));
        assert (null == cache.get((Object)"k2")) : "Should not see uncommitted changes";
        Transaction read = tm.suspend();
        tm.resume(write);
        tm.commit();
        this.assertNoLocks();
        tm.resume(read);
        if (this.repeatableRead) {
            assert (null == cache.get((Object)"k2")) : "Should have repeatable read";
        } else assert ("v2".equals(cache.get((Object)"k2"))) : "Read committed should see committed changes";
        tm.commit();
        this.assertNoLocks();
    }

    public void testUpdateDoesntBlockRead() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        Transaction write = tm.suspend();
        tm.begin();
        assert ("v".equals(cache.get((Object)"k")));
        Transaction read = tm.suspend();
        tm.resume(write);
        tm.commit();
        this.assertNoLocks();
        tm.resume(read);
        if (this.repeatableRead) {
            assert ("v".equals(cache.get((Object)"k"))) : "Should have repeatable read";
        } else assert ("v2".equals(cache.get((Object)"k"))) : "Read committed should see committed changes";
        tm.commit();
        this.assertNoLocks();
    }

    public void testWriteDoesntBlockReadNonexistent() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        Transaction write = tm.suspend();
        tm.begin();
        assert (null == cache.get((Object)"k")) : "Should not see uncommitted changes";
        Transaction read = tm.suspend();
        tm.resume(write);
        tm.commit();
        this.assertNoLocks();
        tm.resume(read);
        if (this.repeatableRead) {
            assert (null == cache.get((Object)"k")) : "Should have repeatable read";
        } else assert ("v".equals(cache.get((Object)"k"))) : "Read committed should see committed changes";
        tm.commit();
        this.assertNoLocks();
    }

    public void testConcurrentWriters() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        DummyTransactionManager tm = (DummyTransactionManager)tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        DummyTransaction transaction = tm.getTransaction();
        assert (transaction.runPrepare());
        tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        assert (!tm.getTransaction().runPrepare());
        tm.rollback();
        tm.resume((Transaction)transaction);
        transaction.runCommitTx();
        this.assertNoLocks();
    }

    public void testRollbacks() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        assert ("v".equals(cache.get((Object)"k")));
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        tm.rollback();
        tm.resume(reader);
        Object value = cache.get((Object)"k");
        assert ("v".equals(value)) : "Expecting 'v' but was " + value;
        tm.commit();
        assert ("v".equals(cache.get((Object)"k")));
        this.assertNoLocks();
    }

    public void testRollbacksOnNullEntry() throws Exception {
        LockTestBaseTL tl = this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        tm.begin();
        assert (null == cache.get((Object)"k"));
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        assert ("v".equals(cache.get((Object)"k")));
        tm.rollback();
        tm.resume(reader);
        assert (null == cache.get((Object)"k")) : "Expecting null but was " + (String)cache.get((Object)"k");
        tm.commit();
        assert (null == cache.get((Object)"k"));
        this.assertNoLocks();
    }

    protected static final class LockTestBaseTL {
        public Cache<String, String> cache;
        public TransactionManager tm;
        public LockManager lockManager;
        public InvocationContextContainer icc;

        protected LockTestBaseTL() {
        }
    }
}

