/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.EmbeddedCacheManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.RehashCompletedOnJoinTest")
public class RehashCompletedOnJoinTest
extends BaseDistFunctionalTest {
    public RehashCompletedOnJoinTest() {
        this.INIT_CLUSTER_SIZE = 2;
        this.performRehashing = true;
    }

    public void testJoinComplete() {
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(Arrays.asList(new MagicKey(this.c1, "k1"), new MagicKey(this.c2, "k2"), new MagicKey(this.c1, "k3"), new MagicKey(this.c2, "k4")));
        int i = 0;
        for (Cache c : this.caches) {
            c.put(keys.get(i++), (Object)("v" + i));
        }
        this.log.infof("Initialized with keys %s", keys);
        EmbeddedCacheManager joinerManager = this.addClusterEnabledCacheManager();
        joinerManager.defineConfiguration(this.cacheName, this.configuration);
        Cache joiner = joinerManager.getCache(this.cacheName);
        DistributionManager dmi = joiner.getAdvancedCache().getDistributionManager();
        assert (dmi.isJoinComplete());
    }
}

