/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="topologyaware.TopologyInfoBroadcastTest")
public class TopologyInfoBroadcastTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.getClusterConfig(), 3);
        this.updatedSiteInfo(this.manager(0), "s0", "r0", "m0");
        this.updatedSiteInfo(this.manager(1), "s1", "r1", "m1");
        this.updatedSiteInfo(this.manager(2), "s2", "r2", "m2");
        this.log.info((Object)"Here it starts");
        this.waitForClusterToForm();
        this.log.info((Object)"Here it ends");
    }

    protected Configuration getClusterConfig() {
        return TopologyInfoBroadcastTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
    }

    private void updatedSiteInfo(EmbeddedCacheManager embeddedCacheManager, String s, String r, String m) {
        GlobalConfiguration gc = embeddedCacheManager.getGlobalConfiguration();
        gc.setSiteId(s);
        gc.setRackId(r);
        gc.setMachineId(m);
    }

    public void testIsReplicated() {
        assert (this.advancedCache(0).getDistributionManager().getConsistentHash() instanceof TopologyAwareConsistentHash);
        assert (this.advancedCache(1).getDistributionManager().getConsistentHash() instanceof TopologyAwareConsistentHash);
        assert (this.advancedCache(2).getDistributionManager().getConsistentHash() instanceof TopologyAwareConsistentHash);
        DistributionManagerImpl dmi = (DistributionManagerImpl)this.advancedCache(0).getDistributionManager();
        System.out.println("distributionManager.ConsistentHash() = " + dmi.getConsistentHash());
        this.assertTopologyInfo3Nodes(dmi.getConsistentHash().getCaches());
        dmi = (DistributionManagerImpl)this.advancedCache(1).getDistributionManager();
        this.assertTopologyInfo3Nodes(dmi.getConsistentHash().getCaches());
        dmi = (DistributionManagerImpl)this.advancedCache(2).getDistributionManager();
        this.assertTopologyInfo3Nodes(dmi.getConsistentHash().getCaches());
        TopologyAwareConsistentHash tach0 = (TopologyAwareConsistentHash)this.advancedCache(0).getDistributionManager().getConsistentHash();
        TopologyAwareConsistentHash tach1 = (TopologyAwareConsistentHash)this.advancedCache(1).getDistributionManager().getConsistentHash();
        Assert.assertEquals((Set)tach0.getCaches(), (Set)tach1.getCaches());
        TopologyAwareConsistentHash tach2 = (TopologyAwareConsistentHash)this.advancedCache(2).getDistributionManager().getConsistentHash();
        Assert.assertEquals((Set)tach0.getCaches(), (Set)tach2.getCaches());
    }

    @Test(dependsOnMethods={"testIsReplicated"})
    public void testNodeLeaves() {
        TestingUtil.killCacheManagers(this.manager(1));
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0), this.cache(2));
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(2));
        DistributionManagerImpl dmi = (DistributionManagerImpl)this.advancedCache(0).getDistributionManager();
        this.assertTopologyInfo2Nodes(dmi.getConsistentHash().getCaches());
        dmi = (DistributionManagerImpl)this.advancedCache(2).getDistributionManager();
        this.assertTopologyInfo2Nodes(dmi.getConsistentHash().getCaches());
        TopologyAwareConsistentHash tach0 = (TopologyAwareConsistentHash)this.advancedCache(0).getDistributionManager().getConsistentHash();
        TopologyAwareConsistentHash tach2 = (TopologyAwareConsistentHash)this.advancedCache(2).getDistributionManager().getConsistentHash();
        Assert.assertEquals((Set)tach0.getCaches(), (Set)tach2.getCaches());
    }

    private void assertTopologyInfo3Nodes(Set<Address> caches) {
        this.assertTopologyInfo2Nodes(caches);
        TopologyAwareAddress address1 = (TopologyAwareAddress)this.address(1);
        Assert.assertEquals((String)address1.getSiteId(), (String)"s1");
        Assert.assertEquals((String)address1.getRackId(), (String)"r1");
        Assert.assertEquals((String)address1.getMachineId(), (String)"m1");
    }

    private void assertTopologyInfo2Nodes(Set<Address> caches) {
        TopologyAwareAddress address0 = (TopologyAwareAddress)this.address(0);
        Assert.assertEquals((String)address0.getSiteId(), (String)"s0");
        Assert.assertEquals((String)address0.getRackId(), (String)"r0");
        Assert.assertEquals((String)address0.getMachineId(), (String)"m0");
        TopologyAwareAddress address2 = (TopologyAwareAddress)this.address(2);
        Assert.assertEquals((String)address2.getSiteId(), (String)"s2");
        Assert.assertEquals((String)address2.getRackId(), (String)"r2");
        Assert.assertEquals((String)address2.getMachineId(), (String)"m2");
    }
}

