/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.replicated.optimistic;

import java.util.concurrent.CountDownLatch;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.replicated.optimistic.InitiatorCrashOptimisticReplTest")
@CleanupAfterMethod
public class InitiatorCrashOptimisticReplTest
extends AbstractCrashTest {
    public InitiatorCrashOptimisticReplTest() {
        super(Configuration.CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, false);
    }

    public InitiatorCrashOptimisticReplTest(Configuration.CacheMode mode, LockingMode locking, boolean useSync) {
        super(mode, locking, useSync);
    }

    public void testInitiatorNodeCrashesBeforeCommit() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        txControlInterceptor.prepareProgress.countDown();
        this.advancedCache(1).addInterceptor((CommandInterceptor)txControlInterceptor, 1);
        this.beginAndCommitTx("k", 1);
        txControlInterceptor.commitReceived.await();
        this.assertLocked(this.cache(0), (Object)"k");
        this.assertNotLocked(this.cache(1), (Object)"k");
        this.assertNotLocked(this.cache(2), (Object)"k");
        this.checkTxCount(0, 0, 1);
        this.checkTxCount(1, 1, 0);
        this.checkTxCount(2, 0, 1);
        this.killMember(1);
        this.cacheManagers.remove(1);
        this.assertNotLocked("k");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return InitiatorCrashOptimisticReplTest.this.checkTxCount(0, 0, 0) && InitiatorCrashOptimisticReplTest.this.checkTxCount(1, 0, 0);
            }
        });
    }

    public void testInitiatorCrashesBeforeReleasingLock() throws Exception {
        CountDownLatch releaseLocksLatch = new CountDownLatch(1);
        this.prepareCache(releaseLocksLatch);
        this.beginAndCommitTx("k", 1);
        releaseLocksLatch.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.assertLocked(this.cache(0), (Object)"k");
        this.assertNotLocked(this.cache(1), (Object)"k");
        this.assertNotLocked(this.cache(2), (Object)"k");
        this.killMember(1);
        this.cacheManagers.remove(1);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return InitiatorCrashOptimisticReplTest.this.checkTxCount(0, 0, 0) && InitiatorCrashOptimisticReplTest.this.checkTxCount(1, 0, 0);
            }
        });
        this.assertNotLocked("k");
        assert (this.cache(0).get((Object)"k").equals("v"));
        assert (this.cache(1).get((Object)"k").equals("v"));
    }

    public void testInitiatorNodeCrashesBeforePrepare() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        this.advancedCache(1).addInterceptor((CommandInterceptor)txControlInterceptor, 1);
        this.beginAndPrepareTx("k", 1);
        txControlInterceptor.preparedReceived.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 1, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.killMember(1);
        this.cacheManagers.remove(1);
        assert (this.caches().size() == 2);
        txControlInterceptor.prepareProgress.countDown();
        this.assertNotLocked("k");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return InitiatorCrashOptimisticReplTest.this.checkTxCount(0, 0, 0) && InitiatorCrashOptimisticReplTest.this.checkTxCount(1, 0, 0);
            }
        });
    }
}

