/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.multiversion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.AbstractDelegatingMarshaller;
import org.infinispan.marshall.Externalizer;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CherryPickClassLoader;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.Util;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.MultiPojoVersionMarshallTest")
public class MultiPojoVersionMarshallTest
extends AbstractInfinispanTest {
    private static final String BASE = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$";
    private static final String CAR = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Car";
    private static final String CAR_EXT = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$CarExternalizer";
    private static final String PERSON = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Person";
    private static final String PERSON_EXT = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$PersonExternalizer";
    private static final String HOUSE = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$House";
    private static final String HOUSE_EXT = "org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$HouseExternalizer";
    private AbstractDelegatingMarshaller marshaller;
    private EmbeddedCacheManager cm;

    @BeforeTest
    public void setUp() {
        this.cm = TestCacheManagerFactory.createLocalCacheManager(false);
        this.marshaller = TestingUtil.extractCacheMarshaller(this.cm.getCache());
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() {
        this.cm.stop();
    }

    public void testAddIntFieldDiffIspnExternalizer() throws Exception {
        MarshallingMethod method = MarshallingMethod.INFINISPAN;
        byte[] oldCarbytes = this.marshallOldCar(method);
        this.readOldCarWithNewVersion(oldCarbytes, method, true);
    }

    public void testAddStringFieldDiffIspnExternalizer() throws Exception {
        MarshallingMethod method = MarshallingMethod.INFINISPAN;
        byte[] bytes = this.marshallOldPerson(method);
        this.readOldPersonWithNewVersion(bytes, method, true);
    }

    public void testRemoveFieldIspnExternalizer() throws Exception {
        MarshallingMethod method = MarshallingMethod.INFINISPAN;
        byte[] bytes = this.marshallOldHouse(method);
        this.readOldHouseWithNewVersion(bytes, method, true);
    }

    private byte[] marshallOldHouse(MarshallingMethod method) throws Exception {
        Class clazz = Util.loadClass((String)HOUSE, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Object old = clazz.newInstance();
        Field street = clazz.getDeclaredField("street");
        street.set(old, "Rue du Seyon");
        Field number = clazz.getDeclaredField("number");
        number.set(old, 73);
        return this.marshall(old, method);
    }

    private byte[] marshallOldCar(MarshallingMethod method) throws Exception {
        Class oldCarClass = Util.loadClass((String)CAR, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Object oldCar = oldCarClass.newInstance();
        Field oldPlate = oldCarClass.getDeclaredField("plateNumber");
        oldPlate.set(oldCar, "E 1660");
        return this.marshall(oldCar, method);
    }

    private byte[] marshallOldPerson(MarshallingMethod method) throws Exception {
        Class clazz = Util.loadClass((String)PERSON, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Object old = clazz.newInstance();
        Field ageField = clazz.getDeclaredField("age");
        ageField.set(old, 23);
        return this.marshall(old, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOldCarWithNewVersion(byte[] oldCarbytes, MarshallingMethod method, boolean isNewExternalizer) throws Exception {
        String[] included = new String[]{CAR, CAR_EXT};
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        CherryPickClassLoader cherryPickCl = new CherryPickClassLoader(included, null, tccl);
        Thread.currentThread().setContextClassLoader(cherryPickCl);
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(Car.class));
        CtClass carCt = pool.get(CAR);
        try {
            carCt.addField(CtField.make((String)"public int year;", (CtClass)carCt));
            Class carClass = carCt.toClass();
            if (isNewExternalizer) {
                CtClass carExtCt = pool.get(CAR_EXT);
                CtMethod writeObjMeth = carExtCt.getMethod("writeObject", "(Ljava/io/ObjectOutput;Ljava/lang/Object;)V");
                writeObjMeth.setBody("{\n$1.writeObject(((org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Car) $2).plateNumber);\n$1.writeInt(((org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Car) $2).year);\n}\n");
                CtMethod readObjMeth = carExtCt.getMethod("readObject", "(Ljava/io/ObjectInput;)Ljava/lang/Object;");
                readObjMeth.setBody("{\norg.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Car o = new org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Car();\no.plateNumber = (String) $1.readObject();\nint b1 = $1.read();\nSystem.out.println(b1);\nif (b1 != -1) {\n   byte b2 = $1.readByte();\n   byte b3 = $1.readByte();\n   byte b4 = $1.readByte();\n   o.year = ((0xFF & b1) << 24) | ((0xFF & b2) << 16) |\n            ((0xFF & b3) << 8) | (0xFF & b4);\n}\nreturn o;\n}\n");
                carExtCt.toClass();
            }
            Object oldCarFromWire = this.unmarshall(oldCarbytes, method);
            Field plateField = carClass.getDeclaredField("plateNumber");
            AssertJUnit.assertEquals((Object)"E 1660", (Object)plateField.get(oldCarFromWire));
            Field yearField = carClass.getDeclaredField("year");
            AssertJUnit.assertEquals((Object)0, (Object)yearField.get(oldCarFromWire));
            if (isNewExternalizer) {
                Object newCar = carClass.newInstance();
                plateField = carClass.getDeclaredField("plateNumber");
                plateField.set(newCar, "CH 8271");
                yearField = carClass.getDeclaredField("year");
                yearField.set(newCar, 2001);
                byte[] bytes = this.marshall(newCar, method);
                Object readNewCar = this.unmarshall(bytes, method);
                plateField = carClass.getDeclaredField("plateNumber");
                AssertJUnit.assertEquals((Object)"CH 8271", (Object)plateField.get(readNewCar));
                yearField = carClass.getDeclaredField("year");
                AssertJUnit.assertEquals((Object)2001, (Object)yearField.get(readNewCar));
            }
        }
        finally {
            carCt.detach();
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOldPersonWithNewVersion(byte[] bytes, MarshallingMethod method, boolean isNewExternalizer) throws Exception {
        String[] included = new String[]{PERSON, PERSON_EXT};
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        CherryPickClassLoader cherryPickCl = new CherryPickClassLoader(included, null, tccl);
        Thread.currentThread().setContextClassLoader(cherryPickCl);
        ClassPool pool = ClassPool.getDefault();
        CtClass ct = pool.get(PERSON);
        try {
            ct.addField(CtField.make((String)"public String name;", (CtClass)ct));
            Class clazz = ct.toClass();
            if (isNewExternalizer) {
                CtClass extCt = pool.get(PERSON_EXT);
                CtMethod writeObjMeth = extCt.getMethod("writeObject", "(Ljava/io/ObjectOutput;Ljava/lang/Object;)V");
                writeObjMeth.setBody("{\n$1.writeInt(((org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Person) $2).age);\n$1.writeObject(((org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Person) $2).name);\n}\n");
                CtMethod readObjMeth = extCt.getMethod("readObject", "(Ljava/io/ObjectInput;)Ljava/lang/Object;");
                readObjMeth.setBody("{\norg.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Person o = new org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$Person();\no.age = $1.readInt();\ntry {\n   o.name = (String) $1.readObject();\n} catch(java.io.OptionalDataException e) {}\nreturn o;\n}\n");
                extCt.toClass();
            }
            Object oldFromWire = this.unmarshall(bytes, method);
            Field age = clazz.getDeclaredField("age");
            AssertJUnit.assertEquals((Object)23, (Object)age.get(oldFromWire));
            Field name = clazz.getDeclaredField("name");
            AssertJUnit.assertNull((Object)name.get(oldFromWire));
            if (isNewExternalizer) {
                Object newObj = clazz.newInstance();
                age = clazz.getDeclaredField("age");
                age.set(newObj, 34);
                name = clazz.getDeclaredField("name");
                name.set(newObj, "Galder");
                bytes = this.marshall(newObj, method);
                Object newFromWire = this.unmarshall(bytes, method);
                age = clazz.getDeclaredField("age");
                AssertJUnit.assertEquals((Object)34, (Object)age.get(newFromWire));
                name = clazz.getDeclaredField("name");
                AssertJUnit.assertEquals((Object)"Galder", (Object)name.get(newFromWire));
            }
        }
        finally {
            ct.detach();
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOldHouseWithNewVersion(byte[] bytes, MarshallingMethod method, boolean isNewExternalizer) throws Exception {
        String[] included = new String[]{HOUSE, HOUSE_EXT};
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        CherryPickClassLoader cherryPickCl = new CherryPickClassLoader(included, null, tccl);
        Thread.currentThread().setContextClassLoader(cherryPickCl);
        ClassPool pool = ClassPool.getDefault();
        CtClass ct = pool.get(HOUSE);
        try {
            ct.removeField(ct.getField("number"));
            Class clazz = ct.toClass();
            if (isNewExternalizer) {
                CtClass extCt = pool.get(HOUSE_EXT);
                CtMethod writeObjMeth = extCt.getMethod("writeObject", "(Ljava/io/ObjectOutput;Ljava/lang/Object;)V");
                writeObjMeth.setBody("{\n$1.writeInt(0);\n$1.writeObject(((org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$House) $2).street);\n}\n");
                CtMethod readObjMeth = extCt.getMethod("readObject", "(Ljava/io/ObjectInput;)Ljava/lang/Object;");
                readObjMeth.setBody("{\norg.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$House o = new org.infinispan.marshall.multiversion.MultiPojoVersionMarshallTest$House();\ntry {\n   $1.readInt();\n} catch(java.io.OptionalDataException e) {}\no.street = (String) $1.readObject();\nreturn o;\n}\n");
                extCt.toClass();
            }
            Object oldFromWire = this.unmarshall(bytes, method);
            Field street = clazz.getDeclaredField("street");
            AssertJUnit.assertEquals((Object)"Rue du Seyon", (Object)street.get(oldFromWire));
            if (isNewExternalizer) {
                Object newObj = clazz.newInstance();
                street = clazz.getDeclaredField("street");
                street.set(newObj, "Fir Close");
                bytes = this.marshall(newObj, method);
                Object newFromWire = this.unmarshall(bytes, method);
                street = clazz.getDeclaredField("street");
                AssertJUnit.assertEquals((Object)"Fir Close", (Object)street.get(newFromWire));
            }
        }
        finally {
            ct.detach();
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] marshall(Object o, MarshallingMethod method) throws Exception {
        switch (method) {
            case INFINISPAN: 
            case JBOSS_MARSHALLING: {
                return this.getMarshaller().objectToByteBuffer(o);
            }
            case JAVA: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                try {
                    oos.writeObject(o);
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                finally {
                    oos.close();
                    baos.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshall(byte[] bytes, MarshallingMethod method) throws Exception {
        switch (method) {
            case INFINISPAN: 
            case JBOSS_MARSHALLING: {
                return this.getMarshaller().objectFromByteBuffer(bytes);
            }
            case JAVA: {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                try {
                    Object object = ois.readObject();
                    return object;
                }
                finally {
                    bais.close();
                    ois.close();
                }
            }
        }
        return null;
    }

    private AbstractDelegatingMarshaller getMarshaller() {
        return this.marshaller;
    }

    public static enum MarshallingMethod {
        INFINISPAN,
        JAVA,
        JBOSS_MARSHALLING;

    }

    public static class HouseExternalizer
    implements Externalizer<House> {
        public void writeObject(ObjectOutput output, House object) throws IOException {
            output.writeInt(object.number);
            output.writeObject(object.street);
        }

        public House readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            House o = new House();
            o.number = input.readInt();
            o.street = (String)input.readObject();
            return o;
        }
    }

    @SerializeWith(value=HouseExternalizer.class)
    public static class House {
        public String street;
        public int number;
    }

    public static class PersonExternalizer
    implements Externalizer<Person> {
        public void writeObject(ObjectOutput output, Person object) throws IOException {
            output.writeInt(object.age);
        }

        public Person readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Person o = new Person();
            o.age = input.readInt();
            return o;
        }
    }

    @SerializeWith(value=PersonExternalizer.class)
    public static class Person {
        public int age;
    }

    public static class CarExternalizer
    implements Externalizer<Car> {
        public void writeObject(ObjectOutput output, Car object) throws IOException {
            output.writeObject(object.plateNumber);
        }

        public Car readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Car o = new Car();
            o.plateNumber = (String)input.readObject();
            return o;
        }
    }

    @SerializeWith(value=CarExternalizer.class)
    public static class Car {
        public String plateNumber;
    }
}

