/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferFunctionalTest", enabled=true)
public class StateTransferFunctionalTest
extends MultipleCacheManagersTest {
    public static final String A_B_NAME = "a_b_name";
    public static final String A_C_NAME = "a_c_name";
    public static final String A_D_NAME = "a_d_age";
    public static final String A_B_AGE = "a_b_age";
    public static final String A_C_AGE = "a_c_age";
    public static final String A_D_AGE = "a_d_age";
    public static final String JOE = "JOE";
    public static final String BOB = "BOB";
    public static final String JANE = "JANE";
    public static final Integer TWENTY = 20;
    public static final Integer FORTY = 40;
    Configuration config;
    protected final String cacheName;
    private volatile int testCount = 0;
    private static final Log log = LogFactory.getLog(StateTransferFunctionalTest.class);

    public StateTransferFunctionalTest() {
        this("nbst");
    }

    public StateTransferFunctionalTest(String testCacheName) {
        this.cacheName = testCacheName;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.config = StateTransferFunctionalTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        this.config.setSyncReplTimeout(30000L);
        this.config.setFetchInMemoryState(true);
        this.config.setUseLockStriping(false);
    }

    protected EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(new TransportFlags().withMerge(true));
        cm.defineConfiguration(this.cacheName, this.config.clone());
        return cm;
    }

    public void testInitialStateTransfer(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        EmbeddedCacheManager cm1 = this.createCacheManager();
        Cache cache1 = cm1.getCache(this.cacheName);
        this.writeInitialData((Cache<Object, Object>)cache1);
        JoiningNode node = new JoiningNode();
        Cache cache2 = node.getCache(this.cacheName);
        node.waitForJoin(60000L, cache1, cache2);
        node.verifyStateTransfer(cache2);
        this.logTestEnd(m);
    }

    public void testInitialStateTransferCacheNotPresent(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        EmbeddedCacheManager cacheManager1 = this.createCacheManager();
        Cache cache1 = cacheManager1.getCache(this.cacheName);
        this.writeInitialData((Cache<Object, Object>)cache1);
        JoiningNode node = new JoiningNode();
        Cache cache2 = node.getCache(this.cacheName);
        node.waitForJoin(60000L, cache1, cache2);
        node.verifyStateTransfer(cache2);
        cacheManager1.defineConfiguration("otherCache", this.config.clone());
        cacheManager1.getCache("otherCache");
        this.logTestEnd(m);
    }

    public void testConcurrentStateTransfer(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        Cache cache1 = this.createCacheManager().getCache(this.cacheName);
        this.writeInitialData((Cache<Object, Object>)cache1);
        JoiningNode node2 = new JoiningNode();
        Cache cache2 = node2.getCache(this.cacheName);
        cache1.put((Object)"delay", (Object)new DelayTransfer());
        node2.waitForJoin(60000L, cache1, cache2);
        node2.verifyStateTransfer(cache2);
        final JoiningNode node3 = new JoiningNode();
        final JoiningNode node4 = new JoiningNode();
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                node3.getCache(StateTransferFunctionalTest.this.cacheName);
            }
        });
        t1.setName("CacheStarter-Cache3");
        t1.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                node4.getCache(StateTransferFunctionalTest.this.cacheName);
            }
        });
        t2.setName("CacheStarter-Cache4");
        t2.start();
        t1.join();
        t2.join();
        Cache cache3 = node3.getCache(this.cacheName);
        Cache cache4 = node4.getCache(this.cacheName);
        node3.waitForJoin(120000L, cache1, cache2, cache3, cache4);
        node4.waitForJoin(120000L, cache1, cache2, cache3, cache4);
        node3.verifyStateTransfer(cache3);
        node4.verifyStateTransfer(cache4);
        this.logTestEnd(m);
    }

    public void testSTWithThirdWritingNonTxCache(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        this.thirdWritingCacheTest(false);
        this.logTestEnd(m);
    }

    public void testSTWithThirdWritingTxCache(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        this.thirdWritingCacheTest(true);
        this.logTestEnd(m);
    }

    @Test(timeOut=120000L)
    public void testSTWithWritingNonTxThread(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        this.writingThreadTest(false);
        this.logTestEnd(m);
    }

    @Test(timeOut=120000L)
    public void testSTWithWritingTxThread(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        this.writingThreadTest(true);
        this.logTestEnd(m);
    }

    @Test(enabled=false, description="The new state transfer doesn't work with cache or cache manager restarts (yet)")
    public void testInitialStateTransferAfterRestart(Method m) throws Exception {
        ++this.testCount;
        this.logTestStart(m);
        Cache cache1 = this.createCacheManager().getCache(this.cacheName);
        this.writeInitialData((Cache<Object, Object>)cache1);
        JoiningNode node2 = new JoiningNode();
        Cache cache2 = node2.getCache(this.cacheName);
        node2.waitForJoin(60000L, cache1, cache2);
        node2.verifyStateTransfer(cache2);
        cache2.stop();
        cache2.start();
        this.verifyInitialData((Cache<Object, Object>)cache2);
        this.logTestEnd(m);
    }

    private void logTestStart(Method m) {
        this.logTestLifecycle(m, "start");
    }

    private void logTestEnd(Method m) {
        this.logTestLifecycle(m, "end");
    }

    private void logTestLifecycle(Method m, String lifecycle) {
        log.infof("%s %s - %s", (Object)m.getName(), (Object)lifecycle, (Object)this.testCount);
    }

    private void thirdWritingCacheTest(boolean tx) throws InterruptedException {
        Cache cache1 = this.createCacheManager().getCache(this.cacheName);
        Cache cache3 = this.createCacheManager().getCache(this.cacheName);
        TestingUtil.blockUntilViewsReceived(60000L, cache1, cache3);
        this.writeInitialData((Cache<Object, Object>)cache1);
        cache1.put((Object)"delay", (Object)new DelayTransfer());
        WritingThread writerThread = new WritingThread((Cache<Object, Object>)cache3, tx);
        writerThread.start();
        JoiningNode node2 = new JoiningNode();
        Cache cache2 = node2.getCache(this.cacheName);
        node2.waitForJoin(60000L, cache1, cache2, cache3);
        writerThread.stopThread();
        writerThread.join();
        node2.verifyStateTransfer(cache2);
        int count = writerThread.result();
        for (int c = 0; c < count; ++c) {
            Object o = cache2.get((Object)("test" + c));
            assert (new Integer(c).equals(o)) : "Entry under key [test" + c + "] was [" + cache2.get((Object)("test" + c)) + "] but expected [" + c + "]";
        }
    }

    protected void verifyInitialData(Cache<Object, Object> c) {
        Address address = c.getAdvancedCache().getRpcManager().getAddress();
        log.debugf("Checking values on cache " + address, new Object[0]);
        assert (JOE.equals(c.get((Object)A_B_NAME))) : "Incorrect value for key a_b_name";
        assert (TWENTY.equals(c.get((Object)A_B_AGE))) : "Incorrect value for key a_b_age";
        assert (BOB.equals(c.get((Object)A_C_NAME))) : "Incorrect value for key a_c_name";
        assert (FORTY.equals(c.get((Object)A_C_AGE))) : "Incorrect value for key a_c_age";
    }

    protected void writeInitialData(Cache<Object, Object> c) {
        c.put((Object)A_B_NAME, (Object)JOE);
        c.put((Object)A_B_AGE, (Object)TWENTY);
        c.put((Object)A_C_NAME, (Object)BOB);
        c.put((Object)A_C_AGE, (Object)FORTY);
    }

    private void writingThreadTest(boolean tx) throws InterruptedException {
        Cache cache1 = this.createCacheManager().getCache(this.cacheName);
        this.writeInitialData((Cache<Object, Object>)cache1);
        cache1.put((Object)"delay", (Object)new DelayTransfer());
        WritingThread writerThread = new WritingThread((Cache<Object, Object>)cache1, tx);
        writerThread.start();
        this.verifyInitialData((Cache<Object, Object>)cache1);
        JoiningNode node2 = new JoiningNode();
        Cache cache2 = node2.getCache(this.cacheName);
        node2.waitForJoin(60000L, cache1, cache2);
        writerThread.stopThread();
        writerThread.join();
        this.verifyInitialData((Cache<Object, Object>)cache1);
        node2.verifyStateTransfer(cache2);
        int count = writerThread.result();
        for (int c = 0; c < count; ++c) {
            assert (new Integer(c).equals(cache2.get((Object)("test" + c)))) : "Entry under key [test" + c + "] was [" + cache2.get((Object)("test" + c)) + "] but expected [" + c + "]";
        }
    }

    private class JoiningNode {
        private final EmbeddedCacheManager cm;
        private final CountDownLatch latch;
        private final MergeOrViewChangeListener listener;

        private JoiningNode() {
            this.cm = StateTransferFunctionalTest.this.createCacheManager();
            this.latch = new CountDownLatch(1);
            this.listener = new MergeOrViewChangeListener(this.latch);
            this.cm.addListener((Object)this.listener);
        }

        Cache getCache(String cacheName) {
            return this.cm.getCache(cacheName);
        }

        void waitForJoin(long timeout, Cache ... caches) throws InterruptedException {
            TestingUtil.blockUntilViewsReceived(timeout, caches);
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }

        private boolean isStateTransferred() {
            return !this.listener.merged;
        }

        void verifyStateTransfer(Cache cache) {
            if (this.isStateTransferred()) {
                StateTransferFunctionalTest.this.verifyInitialData((Cache<Object, Object>)cache);
            }
        }
    }

    @Listener
    public static class MergeOrViewChangeListener {
        public boolean merged;
        public boolean viewChanged;
        private final CountDownLatch latch;

        public MergeOrViewChangeListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Merged
        public void mergedView(MergeEvent me) {
            log.infof("View merged received %s", (Object)me);
            this.merged = true;
            this.latch.countDown();
        }

        @ViewChanged
        public void viewChanged(ViewChangedEvent e) {
            log.infof("View change received %s", (Object)e);
            this.viewChanged = true;
            this.latch.countDown();
        }
    }

    private static class WritingThread
    extends Thread {
        private final Cache<Object, Object> cache;
        private final boolean tx;
        private volatile boolean stop;
        private volatile int result;
        private TransactionManager tm;

        WritingThread(Cache<Object, Object> cache, boolean tx) {
            super("WriterThread,StateTransferFunctionalTest");
            this.cache = cache;
            this.tx = tx;
            if (tx) {
                this.tm = TestingUtil.getTransactionManager(cache);
            }
            this.setDaemon(true);
        }

        public int result() {
            return this.result;
        }

        @Override
        public void run() {
            int c = 0;
            while (!this.stop) {
                try {
                    if (this.tx) {
                        this.tm.begin();
                    }
                    this.cache.put((Object)("test" + c), (Object)c++);
                    if (!this.tx) continue;
                    this.tm.commit();
                }
                catch (Exception e) {
                    --c;
                    this.stopThread();
                }
            }
            this.result = c;
        }

        public void stopThread() {
            this.stop = true;
        }
    }

    public static class DelayTransfer
    implements Serializable {
        private static final long serialVersionUID = 6361429803359702822L;
        private transient int count;

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            if (this.count++ == 0) {
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

