/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestTestNGListener;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.ITestContext;

public class DebuggingUnitTestNGListener
extends UnitTestTestNGListener {
    private static final Log log = LogFactory.getLog(DebuggingUnitTestNGListener.class);
    private static final Set<String> failedTestDescriptions = new ConcurrentHashSet();

    @Override
    public void onFinish(ITestContext testCxt) {
        super.onFinish(testCxt);
        this.checkCleanedUp(testCxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCleanedUp(ITestContext testCxt) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(new Configuration());
        try {
            cm.start();
            try {
                TestingUtil.blockUntilViewReceived(cm.getCache(), 1, 2000L, true);
            }
            catch (RuntimeException re) {
                failedTestDescriptions.add("CacheManagers alive after test! - " + testCxt.getName() + " " + re.getMessage());
            }
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cm});
    }

    public static void describeErrorsIfAny() {
        if (!failedTestDescriptions.isEmpty()) {
            DebuggingUnitTestNGListener.log("~~~~~~~~~~~~~~~~~~~~~~~~~ TEST HEALTH INFO ~~~~~~~~~~~~~~~~~~~~~~~~~~");
            DebuggingUnitTestNGListener.log("Some tests didn't properly shutdown the CacheManager:");
            for (String errorMsg : failedTestDescriptions) {
                System.out.println("\t" + errorMsg);
            }
            DebuggingUnitTestNGListener.log("~~~~~~~~~~~~~~~~~~~~~~~~~ TEST HEALTH INFO ~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
    }

    private static void log(String s) {
        System.out.println(s);
        log.info((Object)s);
    }
}

