/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.arjuna.objectstore.VolatileStore;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.util.LegacyKeySupportSystemProperties;

public class TransactionSetup {
    public static final String JBOSS_TM = "jbosstm";
    public static final String DUMMY_TM = "dummytm";
    public static final String JTA;
    private static Operations operations;

    private static void init() {
        String property = JTA;
        if (!DUMMY_TM.equalsIgnoreCase(property)) {
            System.out.println("Transaction manager used: JBossTM");
            final String lookup = JBossStandaloneJTAManagerLookup.class.getName();
            final JBossStandaloneJTAManagerLookup instance = new JBossStandaloneJTAManagerLookup();
            operations = new Operations(){

                @Override
                public UserTransaction getUserTransaction() {
                    try {
                        return instance.getUserTransaction();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void cleanup() {
                }

                @Override
                public String getLookup() {
                    return lookup;
                }

                @Override
                public TransactionManager getManager() {
                    try {
                        return instance.getTransactionManager();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        } else {
            System.out.println("Transaction manager used: Dummy");
            final String lookup = DummyTransactionManagerLookup.class.getName();
            final DummyTransactionManagerLookup instance = new DummyTransactionManagerLookup();
            operations = new Operations(){

                @Override
                public UserTransaction getUserTransaction() {
                    2 v0 = this;
                    return v0.instance.getUserTransaction();
                }

                @Override
                public void cleanup() {
                    2 v0 = this;
                    v0.instance.cleanup();
                }

                @Override
                public String getLookup() {
                    return lookup;
                }

                @Override
                public TransactionManager getManager() {
                    try {
                        return instance.getTransactionManager();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    public static TransactionManager getManager() {
        return operations.getManager();
    }

    public static String getManagerLookup() {
        return operations.getLookup();
    }

    public static UserTransaction getUserTransaction() {
        return operations.getUserTransaction();
    }

    public static void cleanup() {
        operations.cleanup();
    }

    static {
        arjPropertyManager.getCoordinatorEnvironmentBean().setCommunicationStore(VolatileStore.class.getName());
        arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreType(VolatileStore.class.getName());
        JTA = LegacyKeySupportSystemProperties.getProperty((String)"infinispan.test.jta.tm", (String)"infinispan.tm");
        TransactionSetup.init();
    }

    private static interface Operations {
        public UserTransaction getUserTransaction();

        public String getLookup();

        public void cleanup();

        public TransactionManager getManager();
    }
}

