/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.batch.BatchContainer;
import org.infinispan.config.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.BatchingAndEnlistmentTest")
public class BatchingAndEnlistmentTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration config = this.getDefaultStandaloneConfig(false);
        config.fluent().invocationBatching();
        return new DefaultCacheManager(config);
    }

    public void testExpectedEnlistmentMode() {
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        assert (tm instanceof BatchModeTransactionManager);
        TransactionTable tt = TestingUtil.getTransactionTable((Cache<Object, Object>)this.cache);
        Assert.assertEquals(tt.getClass(), TransactionTable.class);
        BatchContainer bc = TestingUtil.extractComponent(this.cache, BatchContainer.class);
        this.cache.startBatch();
        this.cache.put((Object)"k", (Object)"v");
        assert (this.getBatchTx(bc).getEnlistedSynchronization().size() == 1);
        assert (this.getBatchTx(bc).getEnlistedResources().size() == 0);
        this.cache.endBatch(true);
        assert (this.getBatchTx(bc) == null);
    }

    private DummyTransaction getBatchTx(BatchContainer bc) {
        return (DummyTransaction)bc.getBatchTransaction();
    }
}

