/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.testng.annotations.Test;

@Test(testName="tx.exception.ReplicationTxExceptionTest")
public class ReplicationTxExceptionTest
extends MultipleCacheManagersTest {
    private ControlledRpcManager controlledRpcManager;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = ReplicationTxExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createCacheManager(config)});
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createCacheManager(config)});
        TestingUtil.blockUntilViewsReceived(10000L, this.cache(0), this.cache(1));
        Cache cache = this.cache(0);
        RpcManager rpcManager = TestingUtil.extractComponent(cache, RpcManager.class);
        this.controlledRpcManager = new ControlledRpcManager(rpcManager);
        TestingUtil.replaceComponent(cache, RpcManager.class, this.controlledRpcManager, true);
        this.controlledRpcManager.setFail(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicationFailure() throws Exception {
        try {
            TransactionManager tm = this.cache(0).getAdvancedCache().getTransactionManager();
            tm.begin();
            this.cache(0).put((Object)"k0", (Object)"v");
            try {
                tm.commit();
                assert (false);
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
        finally {
            this.controlledRpcManager.setFail(false);
        }
    }
}

