/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.transaction.tm.DummyXid;

public abstract class AbstractClusteredTxTest
extends MultipleCacheManagersTest {
    Object k;

    public void testPut() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v");
        this.assertLocking();
    }

    public void testRemove() throws Exception {
        this.tm(0).begin();
        this.cache(0).remove(this.k);
        this.assertLocking();
    }

    public void testReplace() throws Exception {
        this.tm(0).begin();
        this.cache(0).replace(this.k, (Object)"v");
        this.assertLocking();
    }

    public void testClear() throws Exception {
        this.cache(0).put(this.k, (Object)"v");
        this.tm(0).begin();
        this.cache(0).clear();
        this.assertLocking();
    }

    public void testPutAll() throws Exception {
        Map<Object, String> m = Collections.singletonMap(this.k, "v");
        this.tm(0).begin();
        this.cache(0).putAll(m);
        this.assertLocking();
    }

    protected void commit() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm(0);
        try {
            dtm.firstEnlistedResource().commit((Xid)new DummyXid(UUID.randomUUID()), true);
        }
        catch (XAException e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepare() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm(0);
        try {
            dtm.firstEnlistedResource().prepare((Xid)new DummyXid(UUID.randomUUID()));
        }
        catch (XAException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void assertLocking();
}

