/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.AnonymousCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.SecurityContext;

public class AnonymousProvider
implements AuthenticationProvider {
    private final SecurityContext anonymousContext;

    public AnonymousProvider(String anonymousUsername, Set<String> userRoles) {
        CheckArg.isNotEmpty((String)anonymousUsername, (String)"anonymousUsername");
        CheckArg.isNotNull(userRoles, (String)"userRoles");
        this.anonymousContext = new AnonymousSecurityContext(userRoles, anonymousUsername);
    }

    @Override
    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        if (credentials == null) {
            return repositoryContext.with(this.anonymousContext);
        }
        if (credentials instanceof AnonymousCredentials) {
            AnonymousCredentials creds = (AnonymousCredentials)credentials;
            sessionAttributes.putAll(creds.getAttributes());
            return repositoryContext.with(this.anonymousContext);
        }
        if (credentials instanceof GuestCredentials) {
            return repositoryContext.with(this.anonymousContext);
        }
        return null;
    }

    protected final class AnonymousSecurityContext
    implements SecurityContext {
        private final Set<String> userRoles;
        private final String anonymousUsername;

        protected AnonymousSecurityContext(Set<String> userRoles, String anonymousUsername) {
            this.userRoles = userRoles;
            this.anonymousUsername = anonymousUsername;
        }

        @Override
        public boolean isAnonymous() {
            return true;
        }

        @Override
        public String getUserName() {
            return this.anonymousUsername;
        }

        @Override
        public boolean hasRole(String roleName) {
            return this.userRoles.contains(roleName);
        }

        @Override
        public void logout() {
        }
    }
}

