/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.document.MutableDocument;

@Immutable
public abstract class Operation {
    protected final Path parentPath;
    private final int hashCode;

    protected Operation(Path parentPath, int hashCode) {
        this.parentPath = parentPath;
        this.hashCode = hashCode;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public abstract void replay(MutableDocument var1);

    public abstract void rollback(MutableDocument var1);

    public Path getParentPath() {
        return this.parentPath;
    }

    protected MutableDocument mutableParent(MutableDocument delegate) {
        Document parent = delegate;
        for (String fieldName : this.getParentPath()) {
            parent = parent.getDocument(fieldName);
        }
        return parent;
    }

    public abstract Operation clone();

    protected Object cloneValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Document) {
            return ((Document)value).clone();
        }
        if (value instanceof Collection) {
            Collection original = (Collection)value;
            ArrayList<Object> copy = new ArrayList<Object>(original.size());
            for (Object v : original) {
                copy.add(this.cloneValue(v));
            }
            return copy;
        }
        return value;
    }

    protected boolean equalsIfNotNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

