/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.jcr.RepositoryConfiguration;

public class IndexStorage {
    private final EditableDocument queryConfig;
    private CacheContainer cacheContainer;

    IndexStorage(EditableDocument queryConfig) {
        this.queryConfig = queryConfig;
    }

    static IndexStorage defaultStorage(String repositoryName, String dataDirPath) {
        EditableDocument query = Schematic.newDocument();
        EditableDocument indexing = query.getOrCreateDocument("indexing");
        EditableDocument indexStorage = query.getOrCreateDocument("indexStorage");
        EditableDocument backend = indexing.getOrCreateDocument("backend");
        query.set("rebuildUponStartup", (Object)RepositoryConfiguration.QueryRebuild.IF_MISSING.toString().toLowerCase());
        backend.set("type", (Object)"lucene");
        indexStorage.set("type", (Object)"filesystem");
        indexStorage.set("location", (Object)(dataDirPath + "/" + repositoryName + "/indexes"));
        return new IndexStorage(query);
    }

    EditableDocument getQueryConfiguration() {
        return this.queryConfig;
    }

    CacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    void setCacheContainer(CacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }
}

