/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;

@Immutable
public class BooleanValueFactory
extends AbstractValueFactory<Boolean> {
    public BooleanValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.BOOLEAN, decoder, stringValueFactory);
    }

    @Override
    public Boolean create(String value) {
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value.trim());
    }

    @Override
    public Boolean create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Boolean create(int value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(long value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(boolean value) {
        return value;
    }

    @Override
    public Boolean create(float value) {
        throw new ValueFormatException(Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public Boolean create(double value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(BigDecimal value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(Calendar value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(Date value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(Name value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(Path value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(Path.Segment value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(Reference value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(URI value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(UUID value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public Boolean create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Boolean create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Boolean create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    protected Boolean[] createEmptyArray(int length) {
        return new Boolean[length];
    }
}

