/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.LuceneBackendTaskStreamer;
import org.hibernate.search.backend.impl.lucene.WorkspaceFactory;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneBackendQueueProcessor
implements BackendQueueProcessor {
    private static final Log log = LoggerFactory.make();
    private volatile LuceneBackendResources resources;
    private boolean sync;
    private AbstractWorkspaceImpl workspaceOverride;
    private LuceneBackendTaskStreamer streamWorker;

    @Override
    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.sync = BackendFactory.isConfiguredAsSync(props);
        if (this.workspaceOverride == null) {
            this.workspaceOverride = WorkspaceFactory.createWorkspace(indexManager, context, props);
        }
        this.resources = new LuceneBackendResources(context, indexManager, props, this.workspaceOverride);
        this.streamWorker = new LuceneBackendTaskStreamer(this.resources);
    }

    @Override
    public void close() {
        this.resources.shutdown();
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (singleOperation == null) {
            throw new IllegalArgumentException("singleOperation should not be null");
        }
        this.streamWorker.doWork(singleOperation, monitor);
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList == null) {
            throw new IllegalArgumentException("workList should not be null");
        }
        LuceneBackendQueueTask luceneBackendQueueProcessor = new LuceneBackendQueueTask(workList, this.resources, monitor);
        if (this.sync) {
            Future<?> future = this.resources.getQueueingExecutor().submit(luceneBackendQueueProcessor);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                log.interruptedWhileWaitingForIndexActivity(e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new SearchException("Error applying updates to the Lucene index", e.getCause());
            }
        } else {
            this.resources.getQueueingExecutor().execute(luceneBackendQueueProcessor);
        }
    }

    @Override
    public Lock getExclusiveWriteLock() {
        return this.resources.getExclusiveModificationLock();
    }

    public LuceneBackendResources getIndexResources() {
        return this.resources;
    }

    public void setCustomWorkspace(AbstractWorkspaceImpl workspace) {
        this.workspaceOverride = workspace;
    }

    @Override
    public void indexMappingChanged() {
        this.resources = this.resources.onTheFlyRebuild();
    }
}

