/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.msoffice.MSOfficeMetadata;
import org.modeshape.sequencer.msoffice.MSOfficeMetadataReader;

public class MSOfficeMetadataTest {
    @Test
    public void shouldBeAbleToCreateMetadataForWord() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("word.doc");
        this.assertMetadata(is);
    }

    @Test
    public void shouldBeAbleToCreateMetadataForExcel() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("excel.xls");
        this.assertMetadata(is);
    }

    @Test
    public void shouldBeAbleToCreateMetadataForPowerpoint() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("powerpoint.ppt");
        this.assertMetadata(is);
    }

    private void assertMetadata(InputStream is) throws Exception {
        MSOfficeMetadata officeMetadata = MSOfficeMetadataReader.instance((InputStream)is);
        Assert.assertThat((Object)officeMetadata.getComment(), (Matcher)Is.is((Object)"Test Comment"));
        Assert.assertThat((Object)officeMetadata.getAuthor(), (Matcher)Is.is((Object)"Michael Trezzi"));
        Assert.assertThat((Object)officeMetadata.getKeywords(), (Matcher)Is.is((Object)"jboss, test, dna"));
        Assert.assertThat((Object)officeMetadata.getTitle(), (Matcher)Is.is((Object)"Test Document"));
        Assert.assertThat((Object)officeMetadata.getSubject(), (Matcher)Is.is((Object)"Test Subject"));
    }
}

