/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.interception.ServerMessageBodyWriterContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.WriterException;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

public class ServerResponse
extends Response {
    protected Object entity;
    protected int status = 200;
    protected Headers<Object> metadata = new Headers();
    protected Annotation[] annotations;
    protected Type genericType;
    protected PostProcessInterceptor[] postProcessInterceptors;
    protected MessageBodyWriterInterceptor[] messageBodyWriterInterceptors;
    protected Method resourceMethod;
    protected Class resourceClass;
    protected boolean headersCommitted;

    public ServerResponse(Object entity, int status, Headers<Object> metadata) {
        this.entity = entity;
        this.status = status;
        this.metadata = metadata;
    }

    public ServerResponse() {
    }

    public static ServerResponse copyIfNotServerResponse(Response response) {
        if (response instanceof ServerResponse) {
            return (ServerResponse)response;
        }
        ServerResponse serverResponse = new ServerResponse();
        serverResponse.entity = response.getEntity();
        serverResponse.status = response.getStatus();
        if (response.getMetadata() != null) {
            serverResponse.metadata.putAll(response.getMetadata());
        }
        return serverResponse;
    }

    public Method getResourceMethod() {
        return this.resourceMethod;
    }

    public void setResourceMethod(Method resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    public Class getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(Class resourceClass) {
        this.resourceClass = resourceClass;
    }

    public MessageBodyWriterInterceptor[] getMessageBodyWriterInterceptors() {
        return this.messageBodyWriterInterceptors;
    }

    public void setMessageBodyWriterInterceptors(MessageBodyWriterInterceptor[] messageBodyWriterInterceptors) {
        this.messageBodyWriterInterceptors = messageBodyWriterInterceptors;
    }

    public PostProcessInterceptor[] getPostProcessInterceptors() {
        return this.postProcessInterceptors;
    }

    public void setPostProcessInterceptors(PostProcessInterceptor[] postProcessInterceptors) {
        this.postProcessInterceptors = postProcessInterceptors;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMetadata(MultivaluedMap<String, Object> metadata) {
        this.metadata.clear();
        this.metadata.putAll(metadata);
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public void writeTo(HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory) throws WriterException {
        MediaType contentType;
        MessageBodyWriter<?> writer;
        if (this.postProcessInterceptors != null) {
            for (PostProcessInterceptor interceptor : this.postProcessInterceptors) {
                interceptor.postProcess(this);
            }
        }
        if (this.entity == null) {
            response.setStatus(this.getStatus());
            this.commitHeaders(response);
            return;
        }
        Type generic = this.genericType;
        Class<?> type = this.entity.getClass();
        Object ent = this.entity;
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            generic = ge.getType();
            ent = ge.getEntity();
            type = ent.getClass();
        }
        if ((writer = providerFactory.getMessageBodyWriter(type, generic, this.annotations, contentType = this.resolveContentType())) == null) {
            throw new NoMessageBodyWriterFoundFailure(type, contentType);
        }
        try {
            response.setStatus(this.getStatus());
            final HttpResponse theResponse = response;
            CommitHeaderOutputStream.CommitCallback callback = new CommitHeaderOutputStream.CommitCallback(){
                private boolean committed;

                @Override
                public void commit() {
                    if (this.committed) {
                        return;
                    }
                    this.committed = true;
                    ServerResponse.this.commitHeaders(theResponse);
                }
            };
            CommitHeaderOutputStream os = new CommitHeaderOutputStream(response.getOutputStream(), callback);
            long size = writer.getSize(ent, type, generic, this.annotations, contentType);
            if (size > -1L) {
                response.getOutputHeaders().putSingle("Content-Length", String.valueOf(size));
            }
            if (this.messageBodyWriterInterceptors == null || this.messageBodyWriterInterceptors.length == 0) {
                writer.writeTo(ent, type, generic, this.annotations, contentType, this.getMetadata(), os);
            } else {
                ServerMessageBodyWriterContext ctx = new ServerMessageBodyWriterContext(this.messageBodyWriterInterceptors, writer, ent, type, generic, this.annotations, contentType, this.getMetadata(), os, request);
                ctx.proceed();
            }
            callback.commit();
        }
        catch (Exception ex) {
            if (ex instanceof WriterException) {
                throw (WriterException)ex;
            }
            throw new WriterException(ex);
        }
    }

    public MediaType resolveContentType() {
        MediaType responseContentType = null;
        Object type = this.getMetadata().getFirst("Content-Type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf(type.toString());
        return responseContentType;
    }

    public void commitHeaders(HttpResponse response) {
        List cookies;
        if (this.getMetadata() != null && (cookies = (List)this.getMetadata().get("Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                this.getMetadata().remove("Set-Cookie");
            }
        }
        if (this.getMetadata() != null && this.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll(this.getMetadata());
        }
    }
}

