/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.context.Flag;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.UnnnecessaryLoadingTest;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.FlagsEnabledTest")
@CleanupAfterMethod
public class FlagsEnabledTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = FlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        builder.locking().writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ).versioning().enable().scheme(VersioningScheme.SIMPLE).loaders().addCacheLoader().cacheLoader((CacheLoader)new UnnnecessaryLoadingTest.CountingCacheStore()).loaders().addCacheLoader().cacheLoader((CacheLoader)new DummyInMemoryCacheStore()).transaction().syncCommitPhase(true);
        this.createClusteredCaches(2, "replication", builder);
    }

    UnnnecessaryLoadingTest.CountingCacheStore getCacheStore(Cache cache) {
        CacheLoaderManager clm = TestingUtil.extractComponent(cache, CacheLoaderManager.class);
        ChainingCacheStore ccs = (ChainingCacheStore)clm.getCacheLoader();
        UnnnecessaryLoadingTest.CountingCacheStore countingCS = (UnnnecessaryLoadingTest.CountingCacheStore)((Object)ccs.getStores().keySet().iterator().next());
        return countingCS;
    }

    public void testWithFlagsSemantics() {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        assert (this.getCacheStore((Cache)cache1).numLoads == 0);
        assert (this.getCacheStore((Cache)cache2).numLoads == 0);
        AdvancedCache cache1LocalOnly = cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        cache1LocalOnly.put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        assert (this.getCacheStore((Cache)cache1).numLoads == 1);
        assert (this.getCacheStore((Cache)cache2).numLoads == 1);
        assert (this.getCacheStore((Cache)cache2) != this.getCacheStore((Cache)cache1));
        cache1.put((Object)"nonLocal", (Object)"value");
        assert ("value".equals(cache2.get((Object)"nonLocal")));
        assert (this.getCacheStore((Cache)cache1).numLoads == 2);
        assert (this.getCacheStore((Cache)cache2).numLoads == 1);
        AdvancedCache cache1SkipRemoteAndStores = cache1LocalOnly.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE});
        cache1SkipRemoteAndStores.put((Object)"again", (Object)"value");
        assert (this.getCacheStore((Cache)cache1).numLoads == 2);
        assert (this.getCacheStore((Cache)cache2).numLoads == 1);
        assert (cache1.get((Object)"again").equals("value"));
        assert (cache2.get((Object)"again") == null);
        assert (this.getCacheStore((Cache)cache1).numLoads == 2);
        assert (this.getCacheStore((Cache)cache2).numLoads == 2);
        assert (cache2.get((Object)"again") == null);
        assert (this.getCacheStore((Cache)cache2).numLoads == 3);
        assert (cache2.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get((Object)"again") == null);
        assert (this.getCacheStore((Cache)cache2).numLoads == 3);
        assert (this.getCacheStore((Cache)cache1).numLoads == 2);
        assert (cache1LocalOnly.get((Object)"localStored") == null);
        assert (this.getCacheStore((Cache)cache1).numLoads == 3);
    }

    public void testReplicateSkipCacheLoad(Method m) {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        assert (this.getCacheStore((Cache)cache1).numLoads == 0);
        assert (this.getCacheStore((Cache)cache2).numLoads == 0);
        String v = TestingUtil.v(m, 1);
        String k = TestingUtil.k(m, 1);
        cache1.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).put((Object)k, (Object)v);
        assert (v.equals(cache2.get((Object)k)));
        assert (this.getCacheStore((Cache)cache1).numLoads == 0);
        assert (this.getCacheStore((Cache)cache2).numLoads == 0);
    }

    public void testReplicateSkipCacheLoaderWithinTxInCoordinator(Method m) throws Exception {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        this.doReplicateSkipCacheLoaderWithinTx(m, cache1, cache2);
    }

    public void testReplicateSkipCacheLoaderWithinTxInNonCoordinator(Method m) throws Exception {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        this.doReplicateSkipCacheLoaderWithinTx(m, cache2, cache1);
    }

    private void doReplicateSkipCacheLoaderWithinTx(Method m, final AdvancedCache cache1, AdvancedCache cache2) throws Exception {
        assert (this.getCacheStore((Cache)cache1).numLoads == 0);
        assert (this.getCacheStore((Cache)cache2).numLoads == 0);
        final String v = TestingUtil.v(m, 1);
        final String k = TestingUtil.k(m, 1);
        TestingUtil.withTx(cache1.getTransactionManager(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache1.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).put((Object)k, (Object)v);
                return null;
            }
        });
        assert (v.equals(cache2.get((Object)k)));
        assert (this.getCacheStore((Cache)cache1).numLoads == 0);
        assert (this.getCacheStore((Cache)cache2).numLoads == 0);
    }
}

