/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigurationToXmlStringTest {
    @Test
    public void testCanMarshalInfinispanConfigurationToXml() throws Exception {
        InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration((InputStream)this.getClass().getResourceAsStream("/configs/named-cache-test.xml"));
        configuration.parseGlobalConfiguration().fluent().transport().clusterName("MyCluster");
        this.assertXmlStringContains(configuration.toXmlString(), "clusterName=\"MyCluster\"");
    }

    @Test
    public void testCanMarshalGlobalConfigurationToXml() throws Exception {
        GlobalConfiguration configuration = new GlobalConfiguration();
        configuration.fluent().transport().clusterName("MyCluster").siteId("MySite");
        configuration.fluent().globalJmxStatistics();
        this.assertXmlStringContains(configuration.toXmlString(), "clusterName=\"MyCluster\"", "siteId=\"MySite\"", "enabled=\"true\"");
    }

    @Test
    public void testCanMarshalConfigurationToXml() throws Exception {
        Configuration configuration = new Configuration();
        configuration.name = "MyCacheName";
        configuration.fluent().eviction().maxEntries(Integer.valueOf(10)).strategy(EvictionStrategy.LIRS);
        configuration.fluent().locking().concurrencyLevel(Integer.valueOf(123)).isolationLevel(IsolationLevel.NONE);
        this.assertXmlStringContains(configuration.toXmlString(), "name=\"MyCacheName\"", "maxEntries=\"10\"", "strategy=\"LIRS\"", "concurrencyLevel=\"123\"", "isolationLevel=\"NONE\"");
    }

    void assertXmlStringContains(String xmlString, String ... containedFragments) {
        xmlString = this.parseAndEncode(xmlString);
        for (String fragment : containedFragments) {
            Assert.assertTrue((boolean)xmlString.contains(fragment));
        }
    }

    String parseAndEncode(String xmlString) {
        try {
            Object instance = InfinispanConfiguration.getJAXBContext().createUnmarshaller().unmarshal((Reader)new StringReader(xmlString));
            return InfinispanConfiguration.toXmlString((Object)instance);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

