/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Properties;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.StringPropertyReplacementTest")
public class StringPropertyReplacementTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        System.setProperty("test.property.asyncListenerMaxThreads", "2");
        System.setProperty("test.property.IsolationLevel", "READ_COMMITTED");
        System.setProperty("test.property.writeSkewCheck", "true");
        System.setProperty("test.property.SyncCommitPhase", "true");
        return TestCacheManagerFactory.fromXml("configs/string-property-replaced.xml");
    }

    public void testGlobalConfig() {
        Properties asyncListenerExecutorProperties = this.cacheManager.getGlobalConfiguration().getAsyncListenerExecutorProperties();
        asyncListenerExecutorProperties.get("maxThreads").equals("2");
        Properties transportProps = this.cacheManager.getGlobalConfiguration().getTransportProperties();
        assert (transportProps.get("configurationFile").equals("jgroups-tcp.xml"));
    }

    public void testDefaultCache() {
        Configuration configuration = this.cacheManager.getCache().getConfiguration();
        assert (configuration.getIsolationLevel().equals((Object)IsolationLevel.READ_COMMITTED));
        assert (!configuration.isWriteSkewCheck());
        assert (configuration.isSyncCommitPhase());
    }
}

