/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.Iterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distexec.mapreduce.Book;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.BookSearchTest")
public class BookSearchTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() {
        Configuration cfg = BookSearchTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        this.createClusteredCaches(4, cfg);
    }

    public void testBookSearch() {
        Cache c1 = this.cache(0);
        c1.put((Object)"1", (Object)new Book("Seam in Action", "Dan Allen", "Manning"));
        c1.put((Object)"2", (Object)new Book("Hibernate Search in Action", "Emmanuel Bernard and John Griffin", "Manning"));
        c1.put((Object)"3", (Object)new Book("Metaprogramming Ruby", "Paolo Perrotta", "The Pragmatic Programmers"));
        for (int i = 0; i < 4; ++i) {
            this.verifySearch(this.cache(i));
        }
    }

    private void verifySearch(Cache cache) {
        MapReduceTask queryTask = new MapReduceTask(cache);
        queryTask.mappedWith((Mapper)new TitleBookSearcher("Hibernate Search in Action")).reducedWith((Reducer)new BookReducer());
        Map queryResult = queryTask.execute();
        assert (queryResult.size() == 1);
        assert ("Hibernate Search in Action".equals(((Book)queryResult.values().iterator().next()).title));
    }

    static class BookReducer
    implements Reducer<String, Book> {
        BookReducer() {
        }

        public Book reduce(String reducedKey, Iterator<Book> iter) {
            return iter.next();
        }
    }

    static class TitleBookSearcher
    implements Mapper<String, Book, String, Book> {
        final String title;

        public TitleBookSearcher(String title) {
            this.title = title;
        }

        public void map(String key, Book value, Collector<String, Book> collector) {
            if (this.title.equals(value.title)) {
                collector.emit((Object)key, (Object)value);
            }
        }
    }
}

