/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.DefaultConsistentHashTest")
public class DefaultConsistentHashTest
extends AbstractInfinispanTest {
    public DefaultConsistentHash createConsistentHash(List<Address> servers) {
        Configuration c = new Configuration().fluent().hash().consistentHashClass(DefaultConsistentHash.class).build();
        return (DefaultConsistentHash)ConsistentHashHelper.createConsistentHash((Configuration)c, servers);
    }

    public void testSimpleHashing() {
        List<Address> servers = Arrays.asList(new TestAddress(1), new TestAddress(2), new TestAddress(3), new TestAddress(4));
        DefaultConsistentHash ch = this.createConsistentHash(servers);
        Object o = new Object();
        List l1 = ch.locate(o, 2);
        List l2 = ch.locate(o, 2);
        assert (l1.size() == 2);
        assert (((Object)l1).equals(l2));
        assert (l1 != l2);
        Object o2 = new Object(){

            public int hashCode() {
                return 4567890;
            }
        };
        Object o3 = new Object(){

            public int hashCode() {
                return 4567890;
            }
        };
        assert (o2 != o3);
        assert (!o2.equals(o3));
        assert (((Object)ch.locate(o2, 4)).equals(ch.locate(o3, 4)));
    }

    public void testMultipleKeys() {
        List<Address> servers = Arrays.asList(new TestAddress(1), new TestAddress(2), new TestAddress(3), new TestAddress(4));
        DefaultConsistentHash ch = this.createConsistentHash(servers);
        String k1 = "key1";
        String k2 = "key2";
        String k3 = "key3";
        List<Object> keys = Arrays.asList(k1, k2, k3);
        Map locations = ch.locateAll(keys, 3);
        assert (locations.size() == 3);
        for (Object e : keys) {
            assert (locations.containsKey(e));
            assert (((List)locations.get(e)).size() == 3);
        }
    }

    public void testNumHashedNodes() {
        List<Address> servers = Arrays.asList(new TestAddress(1), new TestAddress(2), new TestAddress(3), new TestAddress(4));
        DefaultConsistentHash ch = this.createConsistentHash(servers);
        String[] keys = new String[10000];
        Random r = new Random();
        for (int i = 0; i < 10000; ++i) {
            keys[i] = Integer.toHexString(r.nextInt());
        }
        for (String key : keys) {
            List l = ch.locate((Object)key, 2);
            assert (l.size() == 2) : "Did NOT find 2 owners for key [" + key + "] as expected!  Found " + l;
        }
    }

    public void testEveryNumOwners() {
        for (int nodesCount = 1; nodesCount < 10; ++nodesCount) {
            ArrayList<Address> servers = new ArrayList<Address>(nodesCount);
            for (int i = 0; i < nodesCount; ++i) {
                servers.add(new TestAddress(i * 1000));
            }
            DefaultConsistentHash ch = this.createConsistentHash(servers);
            ArrayList sortedServers = new ArrayList(ch.getCaches());
            for (int numOwners = 1; numOwners < nodesCount; ++numOwners) {
                for (int i = 0; i < nodesCount; ++i) {
                    List owners = ch.locate(sortedServers.get(i), numOwners);
                    Assert.assertEquals((int)owners.size(), (int)numOwners);
                    for (int j = 0; j < numOwners; ++j) {
                        Assert.assertEquals(owners.get(j), sortedServers.get((i + j) % nodesCount));
                    }
                }
            }
            for (int i = 0; i < nodesCount; ++i) {
                List owners = ch.locate(sortedServers.get(i), nodesCount + 1);
                Assert.assertEquals((int)owners.size(), (int)nodesCount);
                for (int j = 0; j < nodesCount; ++j) {
                    Assert.assertEquals(owners.get(j), sortedServers.get((i + j) % nodesCount));
                }
            }
        }
    }
}

