/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="loaders.UnnnecessaryLoadingTest", groups={"functional"}, sequential=true)
public class UnnnecessaryLoadingTest
extends SingleCacheManagerTest {
    CacheStore store;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = this.getDefaultStandaloneConfig(true);
        cfg.setInvocationBatchingEnabled(true);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new CountingCacheStoreConfig());
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg());
        cfg.setCacheLoaderManagerConfig(clmc);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfg);
        this.cache = cm.getCache();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        return cm;
    }

    public void testRepeatedLoads() throws CacheLoaderException {
        CountingCacheStore countingCS = this.getCountingCacheStore();
        this.store.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        assert (countingCS.numLoads == 0);
        assert (countingCS.numContains == 0);
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
    }

    public void testSkipCacheFlagUsage() throws CacheLoaderException {
        CountingCacheStore countingCS = this.getCountingCacheStore();
        this.store.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        assert (countingCS.numLoads == 0);
        assert (countingCS.numContains == 0);
        assert (this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get((Object)"k1") == null);
        assert (countingCS.numLoads == 0);
        assert (countingCS.numContains == 0);
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        this.store.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        Object putReturn = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).put((Object)"k2", (Object)"v2-second");
        assert (putReturn == null);
        assert (countingCS.numLoads == 1) : "Expected 1, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert ("v2-second".equals(this.cache.get((Object)"k2")));
        putReturn = this.cache.put((Object)"k2", (Object)"v2-second");
        assert ("v2-second".equals(putReturn));
        assert ("v2-second".equals(this.store.load((Object)"k2").getValue()));
        assert (countingCS.numLoads == 2) : "Expected 2, was " + countingCS.numLoads;
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        this.cache.containsKey((Object)"k1");
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert (!this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).containsKey((Object)"k3"));
        assert (countingCS.numContains == 0) : "Expected 0, was " + countingCS.numContains;
        assert (countingCS.numLoads == 2) : "Expected 2, was " + countingCS.numLoads;
        boolean batchStarted = this.cache.getAdvancedCache().startBatch();
        assert (batchStarted);
        assert (null == this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get((Object)"k1batch"));
        assert (countingCS.numLoads == 2) : "Expected 2, was " + countingCS.numLoads;
        assert (null == this.cache.getAdvancedCache().get((Object)"k2batch"));
        assert (countingCS.numLoads == 3) : "Expected 3, was " + countingCS.numLoads;
        this.cache.endBatch(true);
    }

    private CountingCacheStore getCountingCacheStore() {
        CacheLoaderManager clm = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class);
        ChainingCacheStore ccs = (ChainingCacheStore)clm.getCacheLoader();
        CountingCacheStore countingCS = (CountingCacheStore)((Object)ccs.getStores().keySet().iterator().next());
        this.reset(this.cache, countingCS);
        return countingCS;
    }

    public void testSkipCacheLoadFlagUsage() throws CacheLoaderException {
        CountingCacheStore countingCS = this.getCountingCacheStore();
        this.store.store(TestInternalCacheEntryFactory.create("home", "Vermezzo"));
        this.store.store(TestInternalCacheEntryFactory.create("home-second", "Newcastle Upon Tyne"));
        assert (countingCS.numLoads == 0);
        assert (this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).get((Object)"home") == null);
        assert (countingCS.numLoads == 0);
        assert (this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).put((Object)"home", (Object)"Newcastle") == null);
        assert (countingCS.numLoads == 0);
        Object put = this.cache.getAdvancedCache().put((Object)"home-second", (Object)"Newcastle Upon Tyne, second");
        Assert.assertEquals((Object)put, (Object)"Newcastle Upon Tyne");
        assert (countingCS.numLoads == 1);
    }

    private void reset(Cache cache, CountingCacheStore countingCS) {
        cache.clear();
        countingCS.numLoads = 0;
        countingCS.numContains = 0;
    }

    public static class CountingCacheStoreConfig
    extends AbstractCacheStoreConfig {
        public CountingCacheStoreConfig() {
            this.setCacheLoaderClassName(CountingCacheStore.class.getName());
        }
    }

    public static class CountingCacheStore
    extends AbstractCacheStore {
        public int numLoads;
        public int numContains;

        public void store(InternalCacheEntry entry) throws CacheLoaderException {
        }

        public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        }

        public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        }

        public void clear() throws CacheLoaderException {
        }

        public boolean remove(Object key) throws CacheLoaderException {
            return false;
        }

        protected void purgeInternal() throws CacheLoaderException {
        }

        public InternalCacheEntry load(Object key) throws CacheLoaderException {
            this.incrementLoads();
            return null;
        }

        public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
            return Collections.emptySet();
        }

        public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
            return Collections.emptySet();
        }

        public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
            return Collections.emptySet();
        }

        public boolean containsKey(Object key) throws CacheLoaderException {
            ++this.numContains;
            return false;
        }

        public Class<? extends CacheLoaderConfig> getConfigurationClass() {
            return CountingCacheStoreConfig.class;
        }

        private void incrementLoads() {
            ++this.numLoads;
        }
    }
}

