/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.locks.containers.AbstractStripedLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantStripedLockContainer;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.LockContainerHashingTest")
public class LockContainerHashingTest
extends AbstractInfinispanTest {
    private AbstractStripedLockContainer stripedLock;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.stripedLock = new ReentrantStripedLockContainer(500);
    }

    public void testHashingDistribution() {
        List<String> keys = this.createRandomKeys(1000);
        HashMap<Lock, Integer> distribution = new HashMap<Lock, Integer>();
        for (String s : keys) {
            Lock lock = this.stripedLock.getLock((Object)s);
            if (distribution.containsKey(lock)) {
                int count = (Integer)distribution.get(lock) + 1;
                distribution.put(lock, count);
                continue;
            }
            distribution.put(lock, 1);
        }
        System.out.println(distribution);
        System.out.println("dist size: " + distribution.size());
        System.out.println("num shared locks: " + this.stripedLock.size());
        assert (distribution.size() <= this.stripedLock.size());
        assert ((double)distribution.size() * 1.5 >= (double)this.stripedLock.size());
    }

    private List<String> createRandomKeys(int number) {
        ArrayList<String> f = new ArrayList<String>(number);
        Random r = new Random();
        int i = number;
        while (f.size() < number) {
            String s = i + "baseKey" + (10000 + i++);
            f.add(s);
        }
        return f;
    }
}

