/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.Collection;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.config.Configuration;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.SingleRpcOnPessimisticLockingTest")
public class SingleRpcOnPessimisticLockingTest
extends MultipleCacheManagersTest {
    private Object k0;
    private CountingRpcManager crm;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = SingleRpcOnPessimisticLockingTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        c.fluent().hash().numOwners(Integer.valueOf(1));
        c.fluent().l1().disable();
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.k0 = this.getKeyForCache(1);
        this.crm = new CountingRpcManager(this.advancedCache(0).getRpcManager());
        this.advancedCache(0).getComponentRegistry().registerComponent((Object)this.crm, RpcManager.class);
        this.advancedCache(0).getComponentRegistry().rewire();
        assert (this.advancedCache(0).getRpcManager().equals(this.crm));
    }

    @BeforeMethod
    void clearStats() {
        this.crm.resetStats();
    }

    public void testSingleGetOnPut() throws Exception {
        Operation o = new Operation(){

            @Override
            public void execute() {
                SingleRpcOnPessimisticLockingTest.this.cache(0).put(SingleRpcOnPessimisticLockingTest.this.k0, (Object)"v0");
            }
        };
        this.runtTest(o);
    }

    public void testSingleGetOnRemove() throws Exception {
        Operation o = new Operation(){

            @Override
            public void execute() {
                SingleRpcOnPessimisticLockingTest.this.cache(0).remove(SingleRpcOnPessimisticLockingTest.this.k0);
            }
        };
        this.runtTest(o);
    }

    private void runtTest(Operation o) throws NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.log.trace((Object)"Here is where the fun starts..");
        this.tm(0).begin();
        o.execute();
        this.assertKeyLockedCorrectly(this.k0);
        Assert.assertEquals((int)this.crm.lockCount, (int)0);
        Assert.assertEquals((int)this.crm.clusterGet, (int)1);
        Assert.assertEquals((int)this.crm.otherCount, (int)0);
        this.tm(0).commit();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return ((SingleRpcOnPessimisticLockingTest)SingleRpcOnPessimisticLockingTest.this).crm.lockCount == 0 && ((SingleRpcOnPessimisticLockingTest)SingleRpcOnPessimisticLockingTest.this).crm.clusterGet == 1 && ((SingleRpcOnPessimisticLockingTest)SingleRpcOnPessimisticLockingTest.this).crm.otherCount == 1;
            }
        });
    }

    private static interface Operation {
        public void execute();
    }

    public static class CountingRpcManager
    implements RpcManager {
        private static final Log log = LogFactory.getLog(CountingRpcManager.class);
        public volatile int lockCount;
        public volatile int clusterGet;
        public volatile int otherCount;
        protected final RpcManager realOne;

        public CountingRpcManager(RpcManager realOne) {
            this.realOne = realOne;
        }

        protected void aboutToInvokeRpc(ReplicableCommand rpcCommand) {
            System.out.println("rpcCommand = " + rpcCommand);
            if (rpcCommand instanceof LockControlCommand) {
                ++this.lockCount;
            } else if (rpcCommand instanceof ClusteredGetCommand) {
                ++this.clusterGet;
            } else {
                ++this.otherCount;
            }
        }

        void resetStats() {
            this.lockCount = 0;
            this.clusterGet = 0;
            this.otherCount = 0;
        }

        public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
            log.trace((Object)"invokeRemotely1");
            this.aboutToInvokeRpc(rpcCommand);
            return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
        }

        public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
            log.trace((Object)"invokeRemotely2");
            this.aboutToInvokeRpc(rpcCommand);
            return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue);
        }

        public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
            log.trace((Object)"invokeRemotely3");
            this.aboutToInvokeRpc(rpcCommand);
            return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout);
        }

        public void invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync) throws RpcException {
            log.trace((Object)"invokeRemotely4");
            this.aboutToInvokeRpc(rpc);
            this.realOne.invokeRemotely(recipients, rpc, sync);
        }

        public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
            log.trace((Object)"invokeRemotely5");
            Map responses = this.realOne.invokeRemotely(recipients, rpc, sync, usePriorityQueue);
            return responses;
        }

        public void broadcastRpcCommand(ReplicableCommand rpc, boolean sync) throws RpcException {
            log.trace((Object)"ControlledRpcManager.broadcastRpcCommand1");
            this.aboutToInvokeRpc(rpc);
            this.realOne.broadcastRpcCommand(rpc, sync);
        }

        public void broadcastRpcCommand(ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
            log.trace((Object)"ControlledRpcManager.broadcastRpcCommand2");
            this.realOne.broadcastRpcCommand(rpc, sync, usePriorityQueue);
        }

        public void broadcastRpcCommandInFuture(ReplicableCommand rpc, NotifyingNotifiableFuture<Object> future) {
            log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture1");
            this.aboutToInvokeRpc(rpc);
            this.realOne.broadcastRpcCommandInFuture(rpc, future);
        }

        public void broadcastRpcCommandInFuture(ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
            log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture2");
            this.aboutToInvokeRpc(rpc);
            this.realOne.broadcastRpcCommandInFuture(rpc, usePriorityQueue, future);
        }

        public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, NotifyingNotifiableFuture<Object> future) {
            log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture1");
            this.aboutToInvokeRpc(rpc);
            this.realOne.invokeRemotelyInFuture(recipients, rpc, future);
        }

        public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
            log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture2");
            this.aboutToInvokeRpc(rpc);
            this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future);
        }

        public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout) {
            log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture3");
            this.aboutToInvokeRpc(rpc);
            this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future, timeout);
        }

        public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout, boolean ignoreLeavers) {
            log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture4");
            this.aboutToInvokeRpc(rpc);
            this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future, timeout, ignoreLeavers);
        }

        public Transport getTransport() {
            return this.realOne.getTransport();
        }

        public Address getAddress() {
            return this.realOne.getAddress();
        }
    }
}

