/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="ConcurrentCacheManagerTest")
public class ConcurrentCacheManagerTest
extends AbstractCacheTest {
    static final int NUM_CACHES = 4;
    static final int NUM_THREADS = 25;
    private EmbeddedCacheManager cacheManager;

    @BeforeMethod
    protected void setup() throws Exception {
        DefaultCacheManager manager = new DefaultCacheManager();
        for (int i = 0; i < 4; ++i) {
            manager.defineConfiguration("cache" + i, TestCacheManagerFactory.getDefaultConfiguration(true));
        }
        this.cacheManager = manager;
    }

    @AfterMethod
    protected void teardown() {
        TestingUtil.killCacheManagers(this.cacheManager);
    }

    public void testConcurrentGetCacheCalls() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(26);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(25);
        ExecutorService executorService = Executors.newFixedThreadPool(25);
        for (int i = 0; i < 25; ++i) {
            this.log.debug((Object)"Schedule execution");
            final String string = "cache" + i % 4;
            Future<Void> future = executorService.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    try {
                        barrier.await();
                        ConcurrentCacheManagerTest.this.cacheManager.getCache(string).put((Object)"a", (Object)"b");
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        ConcurrentCacheManagerTest.this.log.debug((Object)"Wait for all execution paths to finish");
                        barrier.await();
                    }
                }
            });
            futures.add(future);
        }
        barrier.await();
        barrier.await();
        this.log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdownNow();
    }
}

