/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.AdvancedExternalizerTest;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.jboss.JBossMarshallerTest")
public class JBossMarshallerTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(JBossMarshallerTest.class);
    private EmbeddedCacheManager cm;

    @BeforeTest
    public void setUp() {
        this.cm = TestCacheManagerFactory.createLocalCacheManager(false);
    }

    @AfterTest
    public void tearDown() {
        this.cm.stop();
    }

    public void testInternalDuplicateExternalizerId() throws Exception {
        this.withExpectedInternalFailure((AdvancedExternalizer)new DuplicateIdClass.Externalizer(), "Should have thrown a CacheException reporting the duplicate id");
    }

    public void testInternalExternalIdLimit() {
        this.withExpectedInternalFailure((AdvancedExternalizer)new TooHighIdClass.Externalizer(), "Should have thrown a CacheException indicating that the Id is too high");
    }

    public void testForeignExternalizerIdNegative() {
        this.withExpectedFailure(this.createForeignExternalizerGlobalConfig(-1), "Should have thrown a CacheException reporting that negative ids are not allowed");
    }

    public void testForeignExternalizerIdClash() {
        this.withExpectedFailure(this.createMultiForeignExternalizerGlobalConfig(3456, true), "Should have thrown a CacheException reporting duplicate id");
        this.withExpectedFailure(this.createMultiForeignExternalizerGlobalConfig(5678, true), "Should have thrown a CacheException reporting duplicate id");
    }

    public void testForeignExternalizerWithoutId() {
        this.withExpectedFailure(this.createMultiForeignExternalizerGlobalConfig(9999, false), "Should have thrown a CacheException reporting that no id has been set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForeignExternalizerConfigIdWins() throws Exception {
        GlobalConfiguration globalCfg = this.createForeignExternalizerGlobalConfig(3456);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalCfg);
        try {
            cm.getCache();
            ExternalizerTable extTable = TestingUtil.extractExtTable((CacheContainer)cm);
            AssertJUnit.assertEquals((int)3456, (int)extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaBothObj()));
        }
        finally {
            cm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForeignExternalizerMultiClassTypesViaSameExternalizer() {
        GlobalConfiguration globalCfg = GlobalConfiguration.getNonClusteredDefault();
        globalCfg.fluent().serialization().addAdvancedExternalizer(new AdvancedExternalizer[]{new MultiIdViaClassExternalizer()});
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalCfg);
        try {
            cm.getCache();
            ExternalizerTable extTable = TestingUtil.extractExtTable((CacheContainer)cm);
            assert (767 == extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaConfigObj()));
            assert (767 == extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaAnnotationObj()));
            assert (767 == extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaBothObj()));
        }
        finally {
            cm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForeignExternalizerMultiClassNameTypesViaSameExternalizer() {
        GlobalConfiguration globalCfg = GlobalConfiguration.getNonClusteredDefault();
        globalCfg.fluent().serialization().addAdvancedExternalizer(868, (AdvancedExternalizer)new MultiIdViaClassNameExternalizer());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalCfg);
        try {
            cm.getCache();
            ExternalizerTable extTable = TestingUtil.extractExtTable((CacheContainer)cm);
            assert (868 == extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaConfigObj()));
            assert (868 == extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaAnnotationObj()));
            assert (868 == extTable.getExternalizerId((Object)new AdvancedExternalizerTest.IdViaBothObj()));
        }
        finally {
            cm.stop();
        }
    }

    private GlobalConfiguration createForeignExternalizerGlobalConfig(int id) {
        GlobalConfiguration globalCfg = GlobalConfiguration.getNonClusteredDefault();
        globalCfg.fluent().serialization().addAdvancedExternalizer(id, AdvancedExternalizerTest.IdViaBothObj.Externalizer.class);
        return globalCfg;
    }

    private GlobalConfiguration createMultiForeignExternalizerGlobalConfig(int id, boolean doSetId) {
        GlobalConfiguration globalCfg = GlobalConfiguration.getNonClusteredDefault();
        if (doSetId) {
            globalCfg.fluent().serialization().addAdvancedExternalizer(id, (AdvancedExternalizer)new AdvancedExternalizerTest.IdViaConfigObj.Externalizer());
        } else {
            globalCfg.fluent().serialization().addAdvancedExternalizer(new AdvancedExternalizer[]{new AdvancedExternalizerTest.IdViaConfigObj.Externalizer()});
        }
        globalCfg.fluent().serialization().addAdvancedExternalizer(new AdvancedExternalizer[]{new AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer()});
        globalCfg.fluent().serialization().addAdvancedExternalizer(3456, (AdvancedExternalizer)new AdvancedExternalizerTest.IdViaBothObj.Externalizer());
        return globalCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withExpectedInternalFailure(AdvancedExternalizer ext, String message) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            cm.getCache();
            ExternalizerTable extTable = TestingUtil.extractExtTable((CacheContainer)cm);
            extTable.addInternalExternalizer(ext);
            extTable.start();
            assert (false) : message;
        }
        catch (ConfigurationException ce) {
            log.trace((Object)"Expected exception", (Throwable)ce);
        }
        finally {
            cm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withExpectedFailure(GlobalConfiguration globalCfg, String message) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalCfg);
        try {
            this.getCacheWithExpectedFailure(message, cm);
            this.getCacheWithExpectedFailure(message, cm);
        }
        finally {
            cm.stop();
        }
    }

    private void getCacheWithExpectedFailure(String message, EmbeddedCacheManager cm) {
        try {
            cm.getCache();
            AssertJUnit.fail((String)message);
        }
        catch (ConfigurationException e) {
            log.trace((Object)"Expected exception", (Throwable)e);
        }
    }

    static class MultiIdViaClassNameExternalizer
    extends MultiIdViaClassExternalizer {
        MultiIdViaClassNameExternalizer() {
        }

        @Override
        public Integer getId() {
            return null;
        }

        @Override
        public Set<Class<? extends Object>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Util.loadClass((String)"org.infinispan.marshall.AdvancedExternalizerTest$IdViaConfigObj", (ClassLoader)Thread.currentThread().getContextClassLoader()), Util.loadClass((String)"org.infinispan.marshall.AdvancedExternalizerTest$IdViaAnnotationObj", (ClassLoader)Thread.currentThread().getContextClassLoader()), Util.loadClass((String)"org.infinispan.marshall.AdvancedExternalizerTest$IdViaBothObj", (ClassLoader)Thread.currentThread().getContextClassLoader())});
        }
    }

    static class MultiIdViaClassExternalizer
    extends AbstractExternalizer<Object> {
        private final AdvancedExternalizer idViaConfigObjExt = new AdvancedExternalizerTest.IdViaConfigObj.Externalizer();
        private final AdvancedExternalizer idViaAnnotationObjExt = new AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer();
        private final AdvancedExternalizer idViaBothObjExt = new AdvancedExternalizerTest.IdViaBothObj.Externalizer();

        MultiIdViaClassExternalizer() {
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
            AdvancedExternalizer ext;
            if (object instanceof AdvancedExternalizerTest.IdViaConfigObj) {
                output.write(0);
                ext = this.idViaConfigObjExt;
            } else if (object instanceof AdvancedExternalizerTest.IdViaAnnotationObj) {
                output.write(1);
                ext = this.idViaAnnotationObjExt;
            } else if (object instanceof AdvancedExternalizerTest.IdViaBothObj) {
                output.write(2);
                ext = this.idViaBothObjExt;
            } else {
                throw new CacheException(String.format("Object of type %s is not supported by externalizer %s", object.getClass().getName(), ((Object)((Object)this)).getClass().getName()));
            }
            ext.writeObject(output, object);
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AdvancedExternalizer ext;
            int index = input.read();
            switch (index) {
                case 0: {
                    ext = this.idViaConfigObjExt;
                    break;
                }
                case 1: {
                    ext = this.idViaAnnotationObjExt;
                    break;
                }
                case 2: {
                    ext = this.idViaBothObjExt;
                    break;
                }
                default: {
                    throw new CacheException(String.format("Unknown index (%d) for externalizer %s", index, ((Object)((Object)this)).getClass().getName()));
                }
            }
            return ext.readObject(input);
        }

        public Integer getId() {
            return 767;
        }

        public Set<Class<? extends Object>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AdvancedExternalizerTest.IdViaConfigObj.class, AdvancedExternalizerTest.IdViaAnnotationObj.class, AdvancedExternalizerTest.IdViaBothObj.class});
        }
    }

    static class TooHighIdClass {
        TooHighIdClass() {
        }

        public static class Externalizer
        extends AbstractExternalizer<TooHighIdClass> {
            public TooHighIdClass readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return null;
            }

            public void writeObject(ObjectOutput output, TooHighIdClass object) throws IOException {
            }

            public Integer getId() {
                return 255;
            }

            public Set<Class<? extends TooHighIdClass>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{TooHighIdClass.class});
            }
        }
    }

    static class DuplicateIdClass {
        DuplicateIdClass() {
        }

        public static class Externalizer
        extends AbstractExternalizer<DuplicateIdClass> {
            public DuplicateIdClass readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return null;
            }

            public void writeObject(ObjectOutput output, DuplicateIdClass object) throws IOException {
            }

            public Integer getId() {
                return 0;
            }

            public Set<Class<? extends DuplicateIdClass>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{DuplicateIdClass.class});
            }
        }
    }
}

