/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.AsyncReplTest")
public class AsyncReplTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration asyncConfiguration = AsyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, true);
        this.createClusteredCaches(2, "asyncRepl", asyncConfiguration);
    }

    public void testWithNoTx() throws Exception {
        Cache cache1 = this.cache(0, "asyncRepl");
        Cache cache2 = this.cache(1, "asyncRepl");
        String key = "key";
        this.replListener(cache2).expect(PutKeyValueCommand.class);
        cache1.put((Object)key, (Object)"value1");
        this.replListener(cache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"value1", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)cache2.get((Object)key));
        this.replListener(cache2).expect(PutKeyValueCommand.class);
        cache1.put((Object)key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get((Object)key));
        this.replListener(cache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get((Object)key));
    }

    public void testWithTx() throws Exception {
        Cache cache1 = this.cache(0, "asyncRepl");
        Cache cache2 = this.cache(1, "asyncRepl");
        String key = "key";
        this.replListener(cache2).expect(PutKeyValueCommand.class);
        cache1.put((Object)key, (Object)"value1");
        this.replListener(cache2).waitForRpc();
        this.assertNotLocked(cache1, (Object)key);
        AssertJUnit.assertEquals((Object)"value1", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)cache2.get((Object)key));
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        this.replListener(cache2).expectWithTx(PutKeyValueCommand.class);
        cache1.put((Object)key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)cache2.get((Object)key));
        mgr.commit();
        this.replListener(cache2).waitForRpc();
        this.assertNotLocked(cache1, (Object)key);
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get((Object)key));
        mgr.begin();
        cache1.put((Object)key, (Object)"value3");
        AssertJUnit.assertEquals((Object)"value3", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get((Object)key));
        mgr.rollback();
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get((Object)key));
        this.assertNotLocked(cache1, (Object)key);
    }

    public void simpleTest() throws Exception {
        Cache cache1 = this.cache(0, "asyncRepl");
        Cache cache2 = this.cache(1, "asyncRepl");
        String key = "key";
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.put((Object)key, (Object)"value3");
        mgr.rollback();
        this.assertNotLocked(cache1, (Object)key);
    }
}

