/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncReplTest")
public class SyncReplTest
extends MultipleCacheManagersTest {
    String k = "key";
    String v = "value";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration replSync = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.createClusteredCaches(2, "replSync", replSync);
    }

    public void testBasicOperation() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        cache1.put((Object)this.k, (Object)this.v);
        AssertJUnit.assertEquals((Object)this.v, (Object)cache1.get((Object)this.k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)this.v, (Object)cache2.get((Object)this.k));
        cache2.remove((Object)this.k);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultpleCachesOnSharedTransport() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        Configuration newConf = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.defineConfigurationOnAllManagers("newCache", newConf);
        Cache altCache1 = this.manager(0).getCache("newCache");
        Cache altCache2 = this.manager(1).getCache("newCache");
        try {
            assert (altCache1.isEmpty());
            assert (altCache2.isEmpty());
            cache1.put((Object)this.k, (Object)this.v);
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (altCache1.isEmpty());
            assert (altCache2.isEmpty());
            altCache1.put((Object)this.k, (Object)"value2");
            assert (altCache1.get((Object)this.k).equals("value2"));
            assert (altCache2.get((Object)this.k).equals("value2"));
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
        }
        finally {
            this.removeCacheFromCluster("newCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicateToNonExistentCache() {
        boolean strictPeerToPeer = false;
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        assert (cache1.isEmpty());
        assert (cache2.isEmpty());
        Configuration newConf = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.defineConfigurationOnAllManagers("newCache2", newConf);
        Cache altCache1 = this.manager(0).getCache("newCache2");
        try {
            assert (altCache1.isEmpty());
            cache1.put((Object)this.k, (Object)this.v);
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (altCache1.isEmpty());
            altCache1.put((Object)this.k, (Object)"value2");
            assert (!strictPeerToPeer) : "With strict peer-to-peer enabled the asymmetric put should have failed";
            assert (altCache1.get((Object)this.k).equals("value2"));
            assert (cache1.get((Object)this.k).equals(this.v));
            assert (cache2.get((Object)this.k).equals(this.v));
            assert (this.manager(0).getCache("newCache2").get((Object)this.k).equals("value2"));
        }
        catch (CacheException e) {
            assert (strictPeerToPeer) : "With strict peer-to-peer disabled the asymmetric put should have succeeded";
        }
        finally {
            this.removeCacheFromCluster("newCache2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixingSyncAndAsyncOnSameTransport() throws Exception {
        RpcManagerImpl asyncRpcManager;
        Transport originalTransport;
        block5: {
            Cache cache1 = this.cache(0, "replSync");
            Cache cache2 = this.cache(1, "replSync");
            this.waitForClusterToForm("replSync");
            originalTransport = null;
            RpcManagerImpl rpcManager = null;
            asyncRpcManager = null;
            Map emptyResponses = Collections.emptyMap();
            try {
                Configuration asyncCache = SyncReplTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC);
                asyncCache.setUseAsyncMarshalling(true);
                this.defineConfigurationOnAllManagers("asyncCache", asyncCache);
                Cache asyncCache1 = this.manager(0).getCache("asyncCache");
                Cache asyncCache2 = this.manager(1).getCache("asyncCache");
                this.waitForClusterToForm("asyncCache");
                Transport mockTransport = (Transport)EasyMock.createMock(Transport.class);
                Address mockAddressOne = (Address)EasyMock.createNiceMock(Address.class);
                Address mockAddressTwo = (Address)EasyMock.createNiceMock(Address.class);
                EasyMock.replay((Object[])new Object[]{mockAddressOne, mockAddressTwo});
                LinkedList<Address> addresses = new LinkedList<Address>();
                addresses.add(mockAddressOne);
                addresses.add(mockAddressTwo);
                EasyMock.expect((Object)mockTransport.getAddress()).andReturn((Object)mockAddressOne).anyTimes();
                EasyMock.expect((Object)mockTransport.getMembers()).andReturn(addresses).anyTimes();
                originalTransport = TestingUtil.extractGlobalComponent((CacheContainer)cache1.getCacheManager(), Transport.class);
                rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
                rpcManager.setTransport(mockTransport);
                EasyMock.expect((Object)mockTransport.invokeRemotely((Collection)((List)EasyMock.anyObject()), (ReplicableCommand)((CacheRpcCommand)EasyMock.anyObject()), (ResponseMode)EasyMock.eq((Object)ResponseMode.SYNCHRONOUS), EasyMock.anyLong(), EasyMock.anyBoolean(), (ResponseFilter)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn(emptyResponses).once();
                EasyMock.replay((Object[])new Object[]{mockTransport});
                cache1.put((Object)"k", (Object)"v");
                EasyMock.verify((Object[])new Object[]{mockTransport});
                asyncRpcManager = (RpcManagerImpl)TestingUtil.extractComponent(asyncCache1, RpcManager.class);
                asyncRpcManager.setTransport(mockTransport);
                EasyMock.reset((Object[])new Object[]{mockTransport});
                EasyMock.expect((Object)mockTransport.getAddress()).andReturn((Object)mockAddressOne).anyTimes();
                EasyMock.expect((Object)mockTransport.getMembers()).andReturn(addresses).anyTimes();
                EasyMock.expect((Object)mockTransport.invokeRemotely((Collection)((List)EasyMock.anyObject()), (ReplicableCommand)((CacheRpcCommand)EasyMock.anyObject()), (ResponseMode)EasyMock.eq((Object)ResponseMode.ASYNCHRONOUS), EasyMock.anyLong(), EasyMock.anyBoolean(), (ResponseFilter)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn(emptyResponses).once();
                EasyMock.replay((Object[])new Object[]{mockTransport});
                asyncCache1.put((Object)"k", (Object)"v");
                EasyMock.verify((Object[])new Object[]{mockTransport});
                if (rpcManager == null) break block5;
            }
            catch (Throwable throwable) {
                if (rpcManager != null) {
                    rpcManager.setTransport(originalTransport);
                }
                if (asyncRpcManager != null) {
                    asyncRpcManager.setTransport(originalTransport);
                }
                throw throwable;
            }
            rpcManager.setTransport(originalTransport);
        }
        if (asyncRpcManager != null) {
            asyncRpcManager.setTransport(originalTransport);
        }
    }
}

