/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import java.io.Serializable;
import javax.transaction.RollbackException;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.exception.ExceptionInCommandTest")
public class ExceptionInCommandTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(Configuration.CacheMode.REPL_SYNC, 2);
        this.waitForClusterToForm();
    }

    public void testPutThrowsLocalException() throws Exception {
        block3: {
            this.tm(0).begin();
            Delta d = new Delta(){

                public DeltaAware merge(DeltaAware d) {
                    throw new RuntimeException("Induced!");
                }
            };
            try {
                this.cache(0).put((Object)"k", (Object)d);
                assert (false);
            }
            catch (RuntimeException e) {
                if ($assertionsDisabled || this.tx(0).getStatus() == 1) break block3;
                throw new AssertionError();
            }
        }
    }

    @Test(expectedExceptions={RollbackException.class})
    public void testPutThrowsRemoteException() throws Exception {
        this.tm(0).begin();
        MyDelta d = new MyDelta();
        d.setCreator();
        this.cache(0).put((Object)"k", (Object)d);
        this.tm(0).commit();
    }

    private static class MyDelta
    implements Delta,
    Serializable {
        transient Thread creator;

        private MyDelta() {
        }

        public void setCreator() {
            this.creator = Thread.currentThread();
        }

        public DeltaAware merge(DeltaAware d) {
            if (this.creator != Thread.currentThread()) {
                throw new RuntimeException("Induced!");
            }
            return new AtomicHashMap();
        }
    }
}

