/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="tx.recovery.LocalRecoveryTest")
public class LocalRecoveryTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(true);
        cm.getDefaultConfiguration().fluent().transaction().transactionManagerLookupClass(RecoveryDummyTransactionManagerLookup.class).recovery().locking().useLockStriping(Boolean.valueOf(false));
        return cm;
    }

    public void testOneTx() throws Exception {
        this.dummyTm().begin();
        this.cache.put((Object)"k", (Object)"v");
        TransactionXaAdapter xaRes = (TransactionXaAdapter)this.dummyTm().firstEnlistedResource();
        RecoveryTestUtil.assertPrepared(0, this.dummyTm().getTransaction());
        xaRes.prepare(xaRes.getLocalTransaction().getXid());
        RecoveryTestUtil.assertPrepared(1, this.dummyTm().getTransaction());
        DummyTransaction suspend = (DummyTransaction)this.dummyTm().suspend();
        xaRes.commit(xaRes.getLocalTransaction().getXid(), false);
        RecoveryTestUtil.assertPrepared(0, suspend);
        Assert.assertEquals((int)0, (int)TestingUtil.getTransactionTable((Cache<Object, Object>)this.cache).getLocalTxCount());
    }

    public void testMultipleTransactions() throws Exception {
        DummyTransaction suspend1 = this.beginTx();
        DummyTransaction suspend2 = this.beginTx();
        DummyTransaction suspend3 = this.beginTx();
        DummyTransaction suspend4 = this.beginTx();
        RecoveryTestUtil.assertPrepared(0, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend1);
        RecoveryTestUtil.assertPrepared(1, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend2);
        RecoveryTestUtil.assertPrepared(2, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend3);
        RecoveryTestUtil.assertPrepared(3, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend4);
        RecoveryTestUtil.assertPrepared(4, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend1);
        RecoveryTestUtil.assertPrepared(3, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend2);
        RecoveryTestUtil.assertPrepared(2, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend3);
        RecoveryTestUtil.assertPrepared(1, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend4);
        RecoveryTestUtil.assertPrepared(0, suspend1, suspend2, suspend3, suspend4);
        Assert.assertEquals((int)0, (int)TestingUtil.getTransactionTable((Cache<Object, Object>)this.cache).getLocalTxCount());
    }

    private DummyTransaction beginTx() {
        return RecoveryTestUtil.beginAndSuspendTx(this.cache);
    }

    private DummyTransactionManager dummyTm() {
        return (DummyTransactionManager)this.tm();
    }
}

