/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import java.util.List;
import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.xa.recovery.SerializableXid;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.RecoveryWithDefaultCacheDistTest")
@CleanupAfterMethod
public class RecoveryWithDefaultCacheDistTest
extends MultipleCacheManagersTest {
    Configuration configuration;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configuration = this.configure();
        this.createCluster(this.configuration, 2);
        this.waitForClusterToForm();
        this.manager(0).getCacheNames().contains(this.getRecoveryCacheName());
        this.manager(1).getCacheNames().contains(this.getRecoveryCacheName());
    }

    protected Configuration configure() {
        Configuration configuration = RecoveryWithDefaultCacheDistTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        configuration.fluent().locking().useLockStriping(Boolean.valueOf(false));
        configuration.fluent().transaction().transactionManagerLookupClass(RecoveryDummyTransactionManagerLookup.class).recovery();
        configuration.fluent().clustering().hash().rehashEnabled(Boolean.valueOf(false));
        return configuration;
    }

    public void testSimpleTx() throws Exception {
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v");
        this.tm(0).commit();
        assert (this.cache(1).get((Object)"k").equals("v"));
    }

    public void testLocalAndRemoteTransaction() throws Exception {
        DummyTransaction t0 = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        DummyTransaction t1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.assertPrepared(0, t0, t1);
        RecoveryTestUtil.prepareTransaction(t0);
        RecoveryTestUtil.assertPrepared(1, t0);
        RecoveryTestUtil.assertPrepared(0, t1);
        RecoveryTestUtil.prepareTransaction(t1);
        RecoveryTestUtil.assertPrepared(1, t0);
        RecoveryTestUtil.assertPrepared(1, t1);
        RecoveryTestUtil.commitTransaction(t0);
        RecoveryTestUtil.assertPrepared(0, t0);
        RecoveryTestUtil.assertPrepared(1, t1);
        RecoveryTestUtil.commitTransaction(t1);
        RecoveryTestUtil.assertPrepared(0, t0);
        RecoveryTestUtil.assertPrepared(0, t1);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                boolean noPrepTxOnFirstNode = RecoveryWithDefaultCacheDistTest.this.cache(0, RecoveryWithDefaultCacheDistTest.this.getRecoveryCacheName()).size() == 0;
                boolean noPrepTxOnSecondNode = RecoveryWithDefaultCacheDistTest.this.cache(1, RecoveryWithDefaultCacheDistTest.this.getRecoveryCacheName()).size() == 0;
                return noPrepTxOnFirstNode & noPrepTxOnSecondNode;
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                Set inDoubt = RecoveryTestUtil.rm(RecoveryWithDefaultCacheDistTest.this.cache(0)).getInDoubtTransactionInfo();
                System.out.println("inDoubt = " + inDoubt);
                return inDoubt.size() == 0;
            }
        });
    }

    public void testNodeCrashesAfterPrepare() throws Exception {
        DummyTransaction t1_1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_1);
        DummyTransaction t1_2 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_2);
        DummyTransaction t1_3 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_3);
        this.manager(1).stop();
        this.cacheManagers.remove(1);
        TestingUtil.blockUntilViewReceived(this.cache(0), 1, 60000L, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                int size = RecoveryTestUtil.rm(RecoveryWithDefaultCacheDistTest.this.cache(0)).getInDoubtTransactionInfo().size();
                return size == 3;
            }
        });
        List inDoubtTransactions = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactions();
        Assert.assertEquals((int)3, (int)inDoubtTransactions.size());
        assert (inDoubtTransactions.contains(new SerializableXid(t1_1.getXid())));
        assert (inDoubtTransactions.contains(new SerializableXid(t1_2.getXid())));
        assert (inDoubtTransactions.contains(new SerializableXid(t1_3.getXid())));
        this.configuration.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.addClusterEnabledCacheManager(this.configuration);
        this.defineRecoveryCache(1);
        TestingUtil.blockUntilViewsReceived(60000L, this.cache(0), this.cache(1));
        DummyTransaction t1_4 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_4);
        this.log.trace((Object)"Before main recovery call.");
        RecoveryTestUtil.assertPrepared(4, t1_4);
        RecoveryTestUtil.assertPrepared(1, t1_4);
        RecoveryTestUtil.commitTransaction(t1_4);
        RecoveryTestUtil.assertPrepared(0, t1_4);
        inDoubtTransactions = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactions();
        Assert.assertEquals((int)3, (int)inDoubtTransactions.size());
        assert (inDoubtTransactions.contains(new SerializableXid(t1_1.getXid())));
        assert (inDoubtTransactions.contains(new SerializableXid(t1_2.getXid())));
        assert (inDoubtTransactions.contains(new SerializableXid(t1_3.getXid())));
        t1_4.firstEnlistedResource().forget(t1_1.getXid());
        this.log.info((Object)"returned");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return RecoveryTestUtil.rm(RecoveryWithDefaultCacheDistTest.this.cache(0)).getInDoubtTransactionInfo().size() == 2;
            }
        });
        inDoubtTransactions = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactions();
        Assert.assertEquals((int)2, (int)inDoubtTransactions.size());
        assert (inDoubtTransactions.contains(new SerializableXid(t1_2.getXid())));
        assert (inDoubtTransactions.contains(new SerializableXid(t1_3.getXid())));
        t1_4.firstEnlistedResource().forget(t1_2.getXid());
        t1_4.firstEnlistedResource().forget(t1_3.getXid());
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return RecoveryTestUtil.rm(RecoveryWithDefaultCacheDistTest.this.cache(0)).getInDoubtTransactionInfo().size() == 0;
            }
        });
        Assert.assertEquals((int)0, (int)RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactionInfo().size());
    }

    protected void defineRecoveryCache(int cacheManagerIndex) {
    }

    protected String getRecoveryCacheName() {
        return "__recoveryInfoCacheName__";
    }
}

