/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.demo.embedded.repo;

import java.net.URL;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;

public class EmbeddedRepositoryDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        ModeShapeEngine engine = new ModeShapeEngine();
        engine.start();
        JcrRepository repository = null;
        String repositoryName = null;
        try {
            URL url = EmbeddedRepositoryDemo.class.getClassLoader().getResource("my-repository-config.json");
            RepositoryConfiguration config = RepositoryConfiguration.read((URL)url);
            Problems problems = config.validate();
            if (problems.hasErrors()) {
                System.err.println("Problems starting the engine.");
                System.err.println(problems);
                System.exit(-1);
            }
            repository = engine.deploy(config);
            repositoryName = config.getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
        Session session = null;
        try {
            repository = engine.getRepository(repositoryName);
            session = repository.login("default");
            Node root = session.getRootNode();
            assert (root != null);
            System.out.println("Found the root node in the \"" + session.getWorkspace().getName() + "\" workspace");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.logout();
            }
            System.out.println("Shutting down engine ...");
            try {
                engine.shutdown().get();
                System.out.println("Success!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

