/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.internal.document.CompactJsonWriter;
import org.infinispan.schematic.internal.document.JsonReader;
import org.infinispan.schematic.internal.document.JsonWriter;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JsonReaderParserTest {
    protected boolean print;
    protected Object value;
    protected Document bson;
    protected JsonWriter writer;

    @Before
    public void beforeTest() {
        this.print = false;
        this.writer = new CompactJsonWriter();
    }

    @After
    public void afterTest() {
        this.value = null;
        this.bson = null;
    }

    protected JsonReader.Parser parser(String string) {
        return new JsonReader.Parser(new JsonReader.Tokenizer((Reader)new StringReader(string)), JsonReader.VALUE_FACTORY, JsonReader.DATE_VALUE_MATCHER);
    }

    @Test
    public void shouldParseValueAsNullGivenNoContent() throws Exception {
        this.value = this.parser("").parseValue();
        assert (Null.matches((Object)this.value));
    }

    @Test
    public void shouldParseValueAsNullGivenNullLiteral() throws Exception {
        this.value = this.parser("null").parseValue();
        assert (Null.matches((Object)this.value));
    }

    @Test
    public void shouldParseValueAsNullGivenNullLiteralWithIncorrectCase() throws Exception {
        this.value = this.parser("nULl").parseValue();
        assert (Null.matches((Object)this.value));
    }

    @Test
    public void shouldParseValueGivenTrueBooleanLiteral() throws Exception {
        this.value = this.parser("true").parseValue();
        assert (Boolean.TRUE.equals(this.value));
    }

    @Test
    public void shouldParseValueGivenFalseBooleanLiteral() throws Exception {
        this.value = this.parser("false").parseValue();
        assert (Boolean.FALSE.equals(this.value));
    }

    @Test
    public void shouldParseValueGivenTrueBooleanLiteralWithIncorrectCase() throws Exception {
        this.value = this.parser("TrUe").parseValue();
        assert (Boolean.TRUE.equals(this.value));
    }

    @Test
    public void shouldParseValueGivenFalseBooleanLiteralWithIncorrectCase() throws Exception {
        this.value = this.parser("fAlSE").parseValue();
        assert (Boolean.FALSE.equals(this.value));
    }

    @Test
    public void shouldParseValueGivenIntegerValues() throws Exception {
        assert (new Integer(0).equals(this.parser("0").parseValue()));
        assert (new Integer(-1).equals(this.parser("-1").parseValue()));
        assert (new Integer(1).equals(this.parser("1").parseValue()));
        assert (new Integer(123456).equals(this.parser("123456").parseValue()));
        assert (new Integer(Integer.MAX_VALUE).equals(this.parser("2147483647").parseValue()));
        assert (new Integer(Integer.MIN_VALUE).equals(this.parser("-2147483648").parseValue()));
    }

    @Test
    public void shouldParseValueGivenLongValues() throws Exception {
        assert (new Long(0x80000000L).equals(this.parser("2147483648").parseValue()));
        assert (new Long(-2147483649L).equals(this.parser("-2147483649").parseValue()));
        assert (new Long(Long.MAX_VALUE).equals(this.parser("9223372036854775807").parseValue()));
        assert (new Long(Long.MIN_VALUE).equals(this.parser("-9223372036854775808").parseValue()));
    }

    @Test
    public void shouldParseValueGivenDoubleValues() throws Exception {
        assert (new Double(0.1).equals(this.parser("0.1").parseValue()));
        assert (new Double(1.0).equals(this.parser("1.0").parseValue()));
        assert (new Double(-1.0).equals(this.parser("-1.0").parseValue()));
        assert (new Double(-1000.0).equals(this.parser("-1.0e3").parseValue()));
        assert (new Double(3.4028234663852886E38).equals(this.parser("3.4028234663852886E38").parseValue()));
        assert (new Double(-1.0).equals(this.parser("-1.0").parseValue()));
        assert (new Double(Double.MAX_VALUE).equals(this.parser("1.7976931348623157E308").parseValue()));
        assert (new Double(Double.MIN_VALUE).equals(this.parser("4.9E-324").parseValue()));
    }

    @Test
    public void shouldParseDocumentWithOneField() throws Exception {
        this.bson = (Document)this.parser("{ \"foo\" : 32 }").parseValue();
        this.assertField("foo", 32);
    }

    @Test
    public void shouldParseDocumentWithTwoFields() throws Exception {
        this.bson = (Document)this.parser("{ \"foo\" : 32 , \"bar\" : \"baz\" }").parseValue();
        this.assertField("foo", 32);
        this.assertField("bar", "baz");
    }

    @Test
    public void shouldParseDocumentWithThreeFields() throws Exception {
        this.bson = (Document)this.parser("{ \"foo\" : 32 , \"bar\" : \"baz\", \"bom\" : true }").parseValue();
        this.assertField("foo", 32);
        this.assertField("bar", "baz");
        this.assertField("bom", true);
    }

    @Test
    public void shouldParseDocumentWithNestedDocument() throws Exception {
        this.bson = (Document)this.parser("{ \"foo\" : 32 , \"nested\" : { \"bar\" : \"baz\", \"bom\" : true }}").parseValue();
        this.assertField("foo", 32);
        this.bson = this.bson.getDocument("nested");
        this.assertField("bar", "baz");
        this.assertField("bom", true);
    }

    @Test
    public void shouldParseDocumentWithExtraTrailingFieldDelimiter() throws Exception {
        this.bson = (Document)this.parser("{ \"foo\" : 32 , \"bar\" : \"baz\",  }").parseValue();
        this.assertField("foo", 32);
        this.assertField("bar", "baz");
    }

    @Test
    public void shouldParseDocumentWithExtraFieldDelimiters() throws Exception {
        this.bson = (Document)this.parser("{ \"foo\" : 32 , , \"bar\" : \"baz\",,  }").parseValue();
        this.assertField("foo", 32);
        this.assertField("bar", "baz");
    }

    @Test
    public void shouldParseDocumentWithUuid() throws Exception {
        UUID obj = UUID.randomUUID();
        this.value = this.parser(this.writer.write((Object)obj)).parseValue();
        assert (obj.equals(this.value));
    }

    @Test
    public void shouldParseDocumentWithObjectId() throws Exception {
        ObjectId obj = new ObjectId(300, 200, 9, 15);
        this.value = this.parser(this.writer.write((Object)obj)).parseValue();
        assert (obj.equals(this.value));
    }

    @Test
    public void shouldParseDocumentWithDate() throws Exception {
        Date obj = this.now();
        String dateDoc = this.writer.write((Object)obj);
        this.value = this.parser(dateDoc).parseValue();
        assert (this.value instanceof Date);
    }

    @Test
    public void shouldParseDocumentWithCode() throws Exception {
        Code obj = new Code("foo");
        this.value = this.parser(this.writer.write((Object)obj)).parseValue();
        assert (obj.equals(this.value));
    }

    @Test
    public void shouldParseDocumentWithCodeAndSscope() throws Exception {
        Document scope = (Document)this.parser("{ \"foo\" : 32 }").parseValue();
        CodeWithScope obj = new CodeWithScope("foo", scope);
        this.value = this.parser(this.writer.write((Object)obj)).parseValue();
        assert (obj.equals(this.value));
    }

    @Test
    public void shouldParseDocumentWithBinary() throws Exception {
        byte[] bytes = new byte[]{19, 34, 83, 0};
        Binary obj = new Binary(5, bytes);
        this.value = this.parser(this.writer.write((Object)obj)).parseValue();
        assert (obj.equals(this.value));
    }

    @Test
    public void shouldParseIsoFormat() throws Exception {
        this.value = Bson.getDateParsingFormatter().parse("2011-06-14T16:05:11GMT+00:00");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    @Test
    public void shouldParseMsDateFormat() throws Exception {
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue("\\/Date(2011-06-14T16:05:11GMT+00:00)\\/");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    @Test
    public void shouldParseMsDateFormatWithSpaces() throws Exception {
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue("\\/Date( 2011-06-14T16:05:11GMT+00:00 )\\/");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    @Test
    public void shouldParseEscapedDateFormat() throws Exception {
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue("/Date(2011-06-14T16:05:11GMT+00:00)/");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    protected Date date(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(year, month - 1, day);
        return cal.getTime();
    }

    @Test
    public void shouldParseEscapedDateFormatWithSpaces() throws Exception {
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue("/Date( 2011-06-14T16:05:11GMT+00:00 )/");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    @Test
    public void shouldEvaluateIsoDateWithGmtTimeZone() throws Exception {
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue("2011-06-14T16:05:11GMT+00:00");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    @Test
    public void shouldEvaluateIsoDateWithZuluTimeZone() throws Exception {
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue("2011-06-14T16:05:11Z");
        assert (this.value instanceof Date);
        Date date = (Date)this.value;
        assert (date.after(this.date(2011, 6, 13)));
        assert (date.before(this.date(2011, 6, 16)));
    }

    @Test
    public void shouldParseIsoDateWithZuluTimeZone() throws Exception {
        Date date = this.now();
        this.value = JsonReader.DATE_VALUE_MATCHER.parseValue(Bson.getDateFormatter().format(date));
        assert (this.value instanceof Date);
    }

    protected void print(Object object) {
        if (this.print) {
            System.out.println(object);
            System.out.flush();
        }
    }

    protected Date now() {
        return new Date();
    }

    protected void assertField(String name, Object value) {
        Object actual = this.bson.get(name);
        if (value == null ? !$assertionsDisabled && !Null.matches((Object)actual) : !$assertionsDisabled && !value.equals(actual)) {
            throw new AssertionError();
        }
    }
}

