/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation.spi;

public final class PageKey {
    private static final String SEPARATOR = "#";
    private final String parentId;
    private final String offset;
    private final long blockSize;

    public PageKey(String key) {
        String[] parts = key.split(SEPARATOR);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid block key string " + key + " . Expected parentId|offset|blockSize");
        }
        this.parentId = parts[0];
        this.offset = parts[1];
        try {
            this.blockSize = Long.valueOf(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Block size is not a valid integer: " + parts[2]);
        }
    }

    public PageKey(String parentId, String offset, long blockSize) {
        this.blockSize = blockSize;
        this.offset = offset;
        this.parentId = parentId;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public String getOffsetString() {
        return this.offset;
    }

    public Integer getOffsetInt() {
        try {
            return Integer.valueOf(this.offset);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getParentId() {
        return this.parentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parentId).append(SEPARATOR);
        sb.append(this.offset).append(SEPARATOR);
        sb.append(this.blockSize);
        return sb.toString();
    }
}

