/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.InputStream;
import java.util.Date;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.modeshape.common.logging.Logger;

public class MSOfficeMetadata
implements POIFSReaderListener {
    private static final Logger LOGGER = Logger.getLogger(MSOfficeMetadata.class);
    private String title;
    private String subject;
    private String author;
    private String keywords;
    private String comment;
    private String template;
    private Date lastSaved;
    private String revision;
    private Long totalEditingTime;
    private Date lastPrinted;
    private Date created;
    private int pages;
    private int words;
    private int characters;
    private String creatingApplication;
    private byte[] thumbnail;

    public void setSummaryInformation(SummaryInformation si) {
        this.title = si.getTitle();
        this.subject = si.getSubject();
        this.author = si.getAuthor();
        this.keywords = si.getKeywords();
        this.comment = si.getComments();
        this.template = si.getTemplate();
        this.lastSaved = si.getLastSaveDateTime();
        this.revision = si.getRevNumber();
        this.totalEditingTime = si.getEditTime();
        this.lastPrinted = si.getLastPrinted();
        this.created = si.getCreateDateTime();
        this.pages = si.getPageCount();
        this.words = si.getWordCount();
        this.characters = si.getCharCount();
        this.creatingApplication = si.getApplicationName();
        this.thumbnail = si.getThumbnail();
    }

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        try {
            SummaryInformation si = (SummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
            this.setSummaryInformation(si);
        }
        catch (Exception ex) {
            LOGGER.debug("Error processing the metadata for the MS Office document", new Object[]{ex});
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTemplate() {
        return this.template;
    }

    public Date getLastSaved() {
        return this.lastSaved;
    }

    public String getRevision() {
        return this.revision;
    }

    public Long getTotalEditingTime() {
        return this.totalEditingTime;
    }

    public Date getLastPrinted() {
        return this.lastPrinted;
    }

    public Date getCreated() {
        return this.created;
    }

    public int getPages() {
        return this.pages;
    }

    public int getWords() {
        return this.words;
    }

    public int getCharacters() {
        return this.characters;
    }

    public String getCreatingApplication() {
        return this.creatingApplication;
    }

    public byte[] getThumbnail() {
        return this.thumbnail;
    }
}

