/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.jcr.JcrConverter;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrNode;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.PropertyHelper;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.chemistry.opencmis.jcr.util.FilterIterator;
import org.apache.chemistry.opencmis.jcr.util.Predicate;
import org.apache.chemistry.opencmis.jcr.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrFolder
extends JcrNode {
    private static final Log log = LogFactory.getLog(JcrFolder.class);

    public JcrFolder(Node node, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, typeManager, pathManager, typeHandlerManager);
    }

    public Iterator<JcrNode> getNodes() {
        try {
            final FilterIterator<Node> nodes = new FilterIterator<Node>((Iterator<Node>)this.getNode().getNodes(), this.typeHandlerManager.getNodePredicate());
            Iterator<JcrNode> jcrNodes = new Iterator<JcrNode>(){

                @Override
                public boolean hasNext() {
                    return nodes.hasNext();
                }

                @Override
                public JcrNode next() {
                    return JcrFolder.this.create((Node)nodes.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return new FilterIterator<JcrNode>(jcrNodes, new Predicate<JcrNode>(){

                @Override
                public boolean evaluate(JcrNode node) {
                    try {
                        if (node.isVersionable()) {
                            Version baseVersion = JcrNode.getBaseVersion(node.getNode());
                            return baseVersion.getPredecessors().length > 0;
                        }
                        return true;
                    }
                    catch (RepositoryException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                        throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrNode addNodeFromSource(JcrDocument source, Properties properties) {
        try {
            String destPath = PathManager.createCmisPath(this.getNode().getPath(), source.getName());
            Session session = this.getNode().getSession();
            session.getWorkspace().copy(source.getNode().getPath(), destPath);
            JcrNode jcrNode = this.create(session.getNode(destPath));
            if (properties != null && properties.getProperties() != null) {
                this.updateProperties(jcrNode.getNode(), jcrNode.getTypeId(), properties);
            }
            session.save();
            return jcrNode;
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void delete(boolean allVersions, boolean isPwc) {
        try {
            if (this.getNode().hasNodes()) {
                throw new CmisConstraintException("Folder is not empty!");
            }
            super.delete(allVersions, isPwc);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public FailedToDeleteDataImpl deleteTree() {
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        String id = this.getId();
        try {
            Node node = this.getNode();
            if (JcrFolder.hasCheckOuts(node)) {
                result.setIds(Collections.singletonList(id));
            } else {
                Session session = node.getSession();
                node.remove();
                session.save();
                result.setIds(Collections.emptyList());
            }
        }
        catch (RepositoryException e) {
            result.setIds(Collections.singletonList(id));
        }
        return result;
    }

    @Override
    protected void compileProperties(PropertiesImpl properties, Set<String> filter, ObjectInfoImpl objectInfo) throws RepositoryException {
        super.compileProperties(properties, filter, objectInfo);
        objectInfo.setHasContent(false);
        objectInfo.setSupportsDescendants(true);
        objectInfo.setSupportsFolderTree(true);
        String typeId = this.getTypeIdInternal();
        this.addPropertyString(properties, typeId, filter, "cmis:path", this.pathManager.getPath(this.getNode()));
        if (this.pathManager.isRoot(this.getNode())) {
            objectInfo.setHasParent(false);
        } else {
            objectInfo.setHasParent(true);
            this.addPropertyId(properties, typeId, filter, "cmis:parentId", this.getParent().getObjectId());
        }
    }

    @Override
    protected Set<Action> compileAllowableActions(Set<Action> aas) {
        Set<Action> result = super.compileAllowableActions(aas);
        JcrFolder.setAction(result, Action.CAN_GET_DESCENDANTS, true);
        JcrFolder.setAction(result, Action.CAN_GET_CHILDREN, true);
        JcrFolder.setAction(result, Action.CAN_GET_FOLDER_PARENT, !this.pathManager.isRoot(this.getNode()));
        JcrFolder.setAction(result, Action.CAN_GET_OBJECT_PARENTS, !this.pathManager.isRoot(this.getNode()));
        JcrFolder.setAction(result, Action.CAN_GET_FOLDER_TREE, true);
        JcrFolder.setAction(result, Action.CAN_CREATE_DOCUMENT, true);
        JcrFolder.setAction(result, Action.CAN_CREATE_FOLDER, true);
        JcrFolder.setAction(result, Action.CAN_DELETE_TREE, true);
        return result;
    }

    @Override
    protected Node getContextNode() {
        return this.getNode();
    }

    @Override
    protected String getObjectId() throws RepositoryException {
        return this.isRoot() ? "[root]" : super.getObjectId();
    }

    @Override
    protected BaseTypeId getBaseTypeId() {
        return BaseTypeId.CMIS_FOLDER;
    }

    @Override
    protected String getTypeIdInternal() {
        return "cmis:folder";
    }

    public static void setProperties(Node node, TypeDefinition type, Properties properties) {
        if (properties == null || properties.getProperties() == null) {
            throw new CmisConstraintException("No properties!");
        }
        HashSet<String> addedProps = new HashSet<String>();
        try {
            for (PropertyData prop : properties.getProperties().values()) {
                PropertyDefinition propDef = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
                if (propDef == null) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' is unknown!");
                }
                if (propDef.getId().equals("cmis:objectTypeId")) {
                    log.warn((Object)"Cannot set cmis:objectTypeId. Ignoring");
                    addedProps.add(prop.getId());
                    continue;
                }
                if (propDef.getId().equals("cmis:contentStreamFileName")) {
                    log.warn((Object)"Cannot set cmis:contentStreamFileName. Ignoring");
                    addedProps.add(prop.getId());
                    continue;
                }
                if (propDef.getUpdatability() == Updatability.READONLY) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' is readonly!");
                }
                if (PropertyHelper.isPropertyEmpty(prop)) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' must not be empty!");
                }
                JcrConverter.setProperty(node, prop);
                addedProps.add(prop.getId());
            }
            for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                if (addedProps.contains(propDef.getId()) || propDef.getUpdatability() == Updatability.READONLY) continue;
                PropertyData<?> prop = PropertyHelper.getDefaultValue(propDef);
                if (prop == null && propDef.isRequired().booleanValue()) {
                    throw new CmisConstraintException("Property '" + propDef.getId() + "' is required!");
                }
                if (prop == null) continue;
                JcrConverter.setProperty(node, prop);
            }
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean hasCheckOuts(Node node) throws RepositoryException {
        String xPath = "/*[jcr:isCheckedOut='true']";
        String path = node.getPath();
        if ("/".equals(path)) {
            path = "";
        }
        xPath = '/' + Util.escape(path) + xPath;
        QueryManager queryManager = node.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(xPath, "xpath");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes().hasNext();
    }
}

