/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.query;

import java.util.List;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.query.EvaluatorXPath;
import org.apache.chemistry.opencmis.jcr.query.ParseTreeWalker;
import org.apache.chemistry.opencmis.jcr.query.XPathBuilder;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryWalker;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;
import org.apache.chemistry.opencmis.server.support.query.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryTranslator {
    private final JcrTypeManager typeManager;
    private final EvaluatorXPath evaluator;
    private QueryObject queryObject;

    protected QueryTranslator(JcrTypeManager typeManager) {
        this.typeManager = typeManager;
        this.evaluator = new EvaluatorXPath(){

            protected String jcrPathFromId(String id) {
                return QueryTranslator.this.jcrPathFromId(id);
            }

            protected String jcrPathFromCol(String name) {
                return QueryTranslator.this.jcrPathFromCol(QueryTranslator.this.queryObject.getMainFromName(), name);
            }
        };
    }

    public QueryObject getQueryObject() {
        return this.queryObject;
    }

    public String translateToXPath(String statement) {
        QueryUtil queryUtil = new QueryUtil();
        this.queryObject = new QueryObject((TypeManager)this.typeManager);
        ParseTreeWalker<XPathBuilder> parseTreeWalker = new ParseTreeWalker<XPathBuilder>(this.evaluator);
        CmisQueryWalker walker = queryUtil.traverseStatementAndCatchExc(statement, this.queryObject, parseTreeWalker);
        walker.setDoFullTextParse(false);
        XPathBuilder parseResult = parseTreeWalker.getResult();
        TypeDefinition fromType = QueryTranslator.getFromName(this.queryObject);
        String pathExpression = this.buildPathExpression(fromType, QueryTranslator.getFolderPredicate(parseResult));
        String elementTest = this.buildElementTest(fromType);
        String predicates = this.buildPredicates(fromType, QueryTranslator.getCondition(parseResult));
        String orderByClause = this.buildOrderByClause(fromType, this.queryObject.getOrderBys());
        return "/jcr:root" + pathExpression + elementTest + predicates + orderByClause;
    }

    protected abstract String jcrPathFromId(String var1);

    protected abstract String jcrPathFromCol(TypeDefinition var1, String var2);

    protected abstract String jcrTypeName(TypeDefinition var1);

    protected abstract String jcrTypeCondition(TypeDefinition var1);

    protected String buildPathExpression(TypeDefinition fromType, String folderPredicate) {
        return folderPredicate == null ? "//" : folderPredicate;
    }

    protected String buildElementTest(TypeDefinition fromType) {
        return "element(*," + this.jcrTypeName(fromType) + ")";
    }

    protected String buildPredicates(TypeDefinition fromType, String condition) {
        String typeCondition = this.jcrTypeCondition(fromType);
        if (typeCondition == null) {
            return condition == null ? "" : "[" + condition + "]";
        }
        if (condition == null) {
            return "[" + typeCondition + "]";
        }
        return "[" + typeCondition + " and " + condition + "]";
    }

    protected String buildOrderByClause(TypeDefinition fromType, List<QueryObject.SortSpec> orderBys) {
        StringBuilder orderSpecs = new StringBuilder();
        for (QueryObject.SortSpec orderBy : orderBys) {
            String selector = this.jcrPathFromCol(fromType, orderBy.getSelector().getName());
            boolean ascending = orderBy.isAscending();
            if (orderSpecs.length() > 0) {
                orderSpecs.append(',');
            }
            orderSpecs.append(selector).append(' ').append(ascending ? "ascending" : "descending");
        }
        return orderSpecs.length() > 0 ? "order by " + orderSpecs : "";
    }

    private static String getFolderPredicate(XPathBuilder parseResult) {
        if (parseResult == null) {
            return null;
        }
        String folderPredicate = null;
        for (XPathBuilder p : parseResult.folderPredicates()) {
            if (folderPredicate == null) {
                folderPredicate = p.xPath();
                continue;
            }
            throw new CmisInvalidArgumentException("Query may only contain a single folder predicate");
        }
        if (folderPredicate != null && !Boolean.FALSE.equals(parseResult.eval(false))) {
            throw new CmisInvalidArgumentException("Folder predicate " + folderPredicate + " is not affirmative.");
        }
        return folderPredicate;
    }

    private static TypeDefinition getFromName(QueryObject queryObject) {
        if (queryObject.getTypes().size() != 1) {
            throw new CmisInvalidArgumentException("From must contain one single reference");
        }
        return queryObject.getMainFromName();
    }

    private static String getCondition(XPathBuilder parseResult) {
        return parseResult == null || Boolean.TRUE.equals(parseResult.eval(true)) ? null : parseResult.xPath();
    }
}

