/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.modeshape.jcr.query.lucene.LuceneSearchConfiguration;
import org.modeshape.jcr.query.lucene.basic.DynamicFieldBridge;
import org.modeshape.jcr.query.lucene.basic.NodeInfo;

public class BasicLuceneConfiguration
extends LuceneSearchConfiguration {
    public BasicLuceneConfiguration(String repositoryName, Properties backend, Properties indexing, Properties storage) {
        super(NodeInfo.class, DynamicFieldBridge.class);
        String factoryJndiName;
        String queueJndiName;
        String bufferSize;
        String refresh;
        String accessType;
        String lockingStrategy;
        String sourceBase;
        String indexBase;
        String storageType = storage.getProperty("type");
        if (storageType.equals("ram")) {
            this.setProperty("hibernate.search.default.directory_provider", "ram");
        } else if (storageType.equals("filesystem")) {
            indexBase = storage.getProperty("location");
            String lockingStrategy2 = storage.getProperty("lockingStrategy");
            String accessType2 = storage.getProperty("fileSystemAccessType");
            this.setProperty("hibernate.search.default.directory_provider", "filesystem");
            this.setProperty("hibernate.search.default.indexBase", indexBase);
            this.setProperty("hibernate.search.default.locking_strategy", lockingStrategy2);
            this.setProperty("hibernate.search.default.filesystem_access_type", accessType2);
        } else if (storageType.equals("filesystem-master")) {
            indexBase = storage.getProperty("location");
            sourceBase = storage.getProperty("sourceLocation");
            lockingStrategy = storage.getProperty("lockingStrategy");
            accessType = storage.getProperty("fileSystemAccessType");
            refresh = storage.getProperty("refreshInSeconds");
            bufferSize = storage.getProperty("copyBufferSizeInMegabytes");
            this.setProperty("hibernate.search.default.directory_provider", "filesystem-master");
            this.setProperty("hibernate.search.default.indexBase", indexBase);
            this.setProperty("hibernate.search.default.sourceBase", sourceBase);
            this.setProperty("hibernate.search.default.refresh", refresh);
            this.setProperty("hibernate.search.default.buffer_size_on_copy", bufferSize);
            this.setProperty("hibernate.search.default.locking_strategy", lockingStrategy);
            this.setProperty("hibernate.search.default.filesystem_access_type", accessType);
        } else if (storageType.equals("filesystem-slave")) {
            indexBase = storage.getProperty("location");
            sourceBase = storage.getProperty("sourceLocation");
            lockingStrategy = storage.getProperty("lockingStrategy");
            accessType = storage.getProperty("fileSystemAccessType");
            refresh = storage.getProperty("refreshInSeconds");
            bufferSize = storage.getProperty("copyBufferSizeInMegabytes");
            String retryMarkerLookup = storage.getProperty("retryMarkerLookup");
            String retryInitializePeriod = storage.getProperty("retryInitializePeriodInSeconds");
            this.setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
            this.setProperty("hibernate.search.default.indexBase", indexBase);
            this.setProperty("hibernate.search.default.sourceBase", sourceBase);
            this.setProperty("hibernate.search.default.refresh", refresh);
            this.setProperty("hibernate.search.default.buffer_size_on_copy", bufferSize);
            this.setProperty("hibernate.search.default.retry_marker_lookup", retryMarkerLookup);
            this.setProperty("hibernate.search.default.retry_initialize_period", retryInitializePeriod);
            this.setProperty("hibernate.search.default.locking_strategy", lockingStrategy);
            this.setProperty("hibernate.search.default.filesystem_access_type", accessType);
        } else if (storageType.equals("infinispan")) {
            String lockCacheName = repositoryName + "-index-lock";
            String dataCacheName = repositoryName + "-index-data";
            String metaCacheName = repositoryName + "-index-meta";
            String chunkSize = storage.getProperty("chunkSizeInBytes");
            this.setProperty("hibernate.search.default.directory_provider", "infinispan");
            this.setProperty("hibernate.search.default.locking_cachename", storage.getProperty("lockCacheName"), lockCacheName);
            this.setProperty("hibernate.search.default.data_cachename", storage.getProperty("dataCacheName"), dataCacheName);
            this.setProperty("hibernate.search.default.metadata_cachename", storage.getProperty("metadataCacheName"), metaCacheName);
            this.setProperty("hibernate.search.default.chunk_size", chunkSize);
            String cacheConfigValue = storage.getProperty("cacheConfiguration");
            if (cacheConfigValue != null && cacheConfigValue.trim().length() != 0) {
                File configFile = new File(cacheConfigValue);
                if (configFile.exists() && configFile.isFile() && configFile.canRead() && configFile.getName().endsWith(".xml")) {
                    this.setProperty("hibernate.search.infinispan.configuration_resourcename", configFile.getAbsolutePath());
                } else {
                    this.setProperty("hibernate.search.infinispan.cachemanager_jndiname", cacheConfigValue.trim());
                }
            }
        } else if (storageType.equals("custom")) {
            storageType = storage.getProperty("classname");
            this.setProperty("hibernate.search.default.directory_provider", storageType);
            for (Object keyObj : storage.keySet()) {
                String key = keyObj.toString();
                if (key.equals("classname") || key.equals("classloader") || key.equals("type")) continue;
                this.setProperty("hibernate.search.default." + key, storage.getProperty(key));
            }
        }
        String analyzer = indexing.getProperty("analyzer");
        String similarity = indexing.getProperty("similarity");
        String batchSize = indexing.getProperty("batchSize");
        String indexFormat = indexing.getProperty("indexFormat");
        String readerStrategy = indexing.getProperty("readerStrategy");
        String mode = indexing.getProperty("mode");
        String asyncThreadPoolSize = indexing.getProperty("asyncThreadPoolSize");
        String asyncMaxQueueSize = indexing.getProperty("asyncMaxQueueSize");
        if (!StandardAnalyzer.class.getName().equals(analyzer)) {
            this.setProperty("hibernate.search.analyzer", analyzer);
        }
        this.setProperty("hibernate.search.similarity", similarity);
        this.setProperty("hibernate.search.worker.batch_size", batchSize);
        this.setProperty("hibernate.search.lucene_version", indexFormat);
        this.setProperty("hibernate.search.reader.strategy", readerStrategy);
        this.setProperty("hibernate.search.default.worker.execution", mode);
        this.setProperty("hibernate.search.default.worker.thread_pool.size", asyncThreadPoolSize);
        this.setProperty("hibernate.search.default.worker.buffer_queue.max", asyncMaxQueueSize);
        for (Object keyObj : indexing.keySet()) {
            String key = keyObj.toString();
            if (!key.startsWith("hibernate.search.")) continue;
            String value = indexing.getProperty(key);
            this.setProperty(key, value);
        }
        String backendType = backend.getProperty("type");
        if (backendType.equals("lucene")) {
            this.setProperty("hibernate.search.default.worker.backend", "lucene");
        } else if (backendType.equals("blackhole")) {
            this.setProperty("hibernate.search.default.worker.backend", "blackhole");
        } else if (backendType.equals("jms-master")) {
            queueJndiName = backend.getProperty("queueJndiName");
            factoryJndiName = backend.getProperty("connectionFactoryJndiName");
            this.setProperty("hibernate.search.default.worker.backend", "jms");
            this.setProperty("hibernate.search.default.worker.jms.connection_factory", factoryJndiName);
            this.setProperty("hibernate.search.default.worker.jms.queue", queueJndiName);
        } else if (backendType.equals("jms-slave")) {
            queueJndiName = backend.getProperty("queueJndiName");
            factoryJndiName = backend.getProperty("connectionFactoryJndiName");
            this.setProperty("hibernate.search.default.worker.backend", "jms");
            this.setProperty("hibernate.search.default.worker.jms.queue", queueJndiName);
            this.setProperty("hibernate.search.default.worker.jms.connection_factory", factoryJndiName);
            for (Object keyObj : backend.keySet()) {
                String key = keyObj.toString();
                if (key.equals("type") || key.equals("queueJndiName") || key.equals("connectionFactoryJndiName")) continue;
                this.setProperty("hibernate.search.default.worker.jndi." + key, backend.getProperty(key));
            }
        } else if (backendType.equals("jgroups-master") || backendType.equals("jgroups-slave")) {
            String type = backendType.equals("jgroups-master") ? "jgroupsMaster" : "jgroupsSlave";
            String channel = backend.getProperty("channelName");
            String config = backend.getProperty("channelConfiguration");
            this.setProperty("hibernate.search.default.worker.backend", type);
            this.setProperty("hibernate.search.default.worker.jgroups.clusterName", channel);
            if (BasicLuceneConfiguration.isFileOrClasspath(config)) {
                this.setProperty("hibernate.search.default.worker.backend.jgroups.configurationFile", config);
            } else if (BasicLuceneConfiguration.isJGroupsXml(config)) {
                this.setProperty("hibernate.search.default.worker.backend.jgroups.configurationXml", config);
            } else {
                this.setProperty("hibernate.search.default.worker.backend.jgroups.configurationString", config);
            }
        } else if (storageType.equals("custom")) {
            String classname = backend.getProperty("classname");
            this.setProperty("hibernate.search.default.worker.backend", classname);
        }
    }

    protected static boolean isFileOrClasspath(String value) {
        if (value == null) {
            return false;
        }
        value = value.trim();
        try {
            File file = new File(value);
            if (file.exists() && file.isFile()) {
                return true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            URL url = BasicLuceneConfiguration.class.getClassLoader().getResource(value);
            if (url != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean isJGroupsXml(String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim()).contains("<config") && value.contains("xmlns=\"urn:org:jgroups\"");
    }

    public boolean isIndexMetadataComplete() {
        return true;
    }
}

