/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.BindVariableValue;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.ArithmeticOperator;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Join;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NamedSelector;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.QueryObjectModel;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.SelectQuery;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.model.SetQueryObjectModel;
import org.modeshape.jcr.query.model.Source;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Subquery;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.plan.PlanHints;

public class QueryObjectModelFactory
implements org.modeshape.jcr.api.query.qom.QueryObjectModelFactory {
    public static final String LANGUAGE = "JCR-JQOM";
    private final JcrQueryContext context;

    public QueryObjectModelFactory(JcrQueryContext context) {
        this.context = context;
    }

    protected SelectorName selectorName(String name) {
        return new SelectorName(name);
    }

    public QueryObjectModel createQuery(javax.jcr.query.qom.Source source, javax.jcr.query.qom.Constraint constraint, javax.jcr.query.qom.Ordering[] orderings, javax.jcr.query.qom.Column[] columns) {
        SelectQuery query = this.select(source, constraint, orderings, columns, null, false);
        String statement = Visitors.readable(query, this.context.getExecutionContext());
        PlanHints hints = new PlanHints();
        hints.showPlan = true;
        hints.hasFullTextSearch = true;
        hints.qualifyExpandedColumnNames = true;
        hints.validateColumnExistance = true;
        return new QueryObjectModel(this.context, statement, LANGUAGE, query, hints, null);
    }

    public SetQueryObjectModel createQuery(org.modeshape.jcr.api.query.qom.SetQuery command) {
        SetQuery setQuery = (SetQuery)CheckArg.getInstanceOf((Object)command, SetQuery.class, (String)"command");
        String statement = setQuery.toString();
        PlanHints hints = new PlanHints();
        hints.showPlan = true;
        hints.hasFullTextSearch = true;
        hints.qualifyExpandedColumnNames = true;
        hints.validateColumnExistance = true;
        return new SetQueryObjectModel(this.context, statement, LANGUAGE, setQuery, hints, null);
    }

    public QueryObjectModel createQuery(org.modeshape.jcr.api.query.qom.SelectQuery command) {
        SelectQuery selectQuery = (SelectQuery)CheckArg.getInstanceOf((Object)command, SelectQuery.class, (String)"command");
        String statement = selectQuery.toString();
        PlanHints hints = new PlanHints();
        hints.showPlan = true;
        hints.hasFullTextSearch = true;
        hints.qualifyExpandedColumnNames = true;
        hints.validateColumnExistance = true;
        return new QueryObjectModel(this.context, statement, LANGUAGE, selectQuery, hints, null);
    }

    public SelectQuery select(javax.jcr.query.qom.Source source, javax.jcr.query.qom.Constraint constraint, javax.jcr.query.qom.Ordering[] orderings, javax.jcr.query.qom.Column[] columns, org.modeshape.jcr.api.query.qom.Limit limit, boolean distinct) {
        Source jcrSource = (Source)CheckArg.getInstanceOf((Object)source, Source.class, (String)"source");
        Constraint jcrConstraint = null;
        if (constraint != null) {
            jcrConstraint = (Constraint)CheckArg.getInstanceOf((Object)constraint, Constraint.class, (String)"constraint");
        }
        ArrayList<Object> jcrColumns = null;
        if (columns != null) {
            jcrColumns = new ArrayList<Object>();
            for (int i = 0; i != columns.length; ++i) {
                jcrColumns.add(CheckArg.getInstanceOf((Object)columns[i], Column.class, (String)("column[" + i + "]")));
            }
        }
        ArrayList<Object> jcrOrderings = null;
        if (orderings != null) {
            jcrOrderings = new ArrayList<Object>();
            for (int i = 0; i != orderings.length; ++i) {
                jcrOrderings.add(CheckArg.getInstanceOf((Object)orderings[i], Ordering.class, (String)("orderings[" + i + "]")));
            }
        }
        Limit jcrLimit = limit == null ? Limit.NONE : new Limit(limit.getRowLimit(), limit.getOffset());
        return new SelectQuery(jcrSource, jcrConstraint, jcrOrderings, jcrColumns, jcrLimit, distinct);
    }

    public org.modeshape.jcr.api.query.qom.SetQuery union(org.modeshape.jcr.api.query.qom.QueryCommand left, org.modeshape.jcr.api.query.qom.QueryCommand right, javax.jcr.query.qom.Ordering[] orderings, org.modeshape.jcr.api.query.qom.Limit limit, boolean all) {
        return this.setQuery(left, SetQuery.Operation.UNION, right, orderings, limit, all);
    }

    public SetQuery intersect(org.modeshape.jcr.api.query.qom.QueryCommand left, org.modeshape.jcr.api.query.qom.QueryCommand right, javax.jcr.query.qom.Ordering[] orderings, org.modeshape.jcr.api.query.qom.Limit limit, boolean all) {
        return this.setQuery(left, SetQuery.Operation.INTERSECT, right, orderings, limit, all);
    }

    public SetQuery except(org.modeshape.jcr.api.query.qom.QueryCommand left, org.modeshape.jcr.api.query.qom.QueryCommand right, javax.jcr.query.qom.Ordering[] orderings, org.modeshape.jcr.api.query.qom.Limit limit, boolean all) {
        return this.setQuery(left, SetQuery.Operation.EXCEPT, right, orderings, limit, all);
    }

    public SetQuery setQuery(org.modeshape.jcr.api.query.qom.QueryCommand left, SetQuery.Operation operation, org.modeshape.jcr.api.query.qom.QueryCommand right, javax.jcr.query.qom.Ordering[] orderings, org.modeshape.jcr.api.query.qom.Limit limit, boolean all) {
        QueryCommand jcrLeft = (QueryCommand)CheckArg.getInstanceOf((Object)left, QueryCommand.class, (String)"left");
        QueryCommand jcrRight = (QueryCommand)CheckArg.getInstanceOf((Object)left, QueryCommand.class, (String)"left");
        ArrayList<Object> jcrOrderings = new ArrayList<Object>();
        for (int i = 0; i != orderings.length; ++i) {
            jcrOrderings.add(CheckArg.getInstanceOf((Object)orderings[i], Ordering.class, (String)("orderings[" + i + "]")));
        }
        Limit jcrLimit = limit == null ? Limit.NONE : new Limit(limit.getRowLimit(), limit.getOffset());
        return new SetQuery(jcrLeft, operation, jcrRight, all, jcrOrderings, jcrLimit);
    }

    public NamedSelector selector(String nodeTypeName, String selectorName) {
        CheckArg.isNotNull((Object)nodeTypeName, (String)"nodeTypeName");
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new NamedSelector(this.selectorName(nodeTypeName), this.selectorName(selectorName));
    }

    public Column column(String selectorName, String propertyName, String columnName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        if (propertyName == null) {
            return new Column(this.selectorName(selectorName));
        }
        CheckArg.isNotNull((Object)columnName, (String)"columnName");
        return new Column(this.selectorName(selectorName), propertyName, columnName);
    }

    public Ordering ascending(javax.jcr.query.qom.DynamicOperand operand) {
        DynamicOperand jcrOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)operand, DynamicOperand.class, (String)"operand");
        return new Ordering(jcrOperand, Order.ASCENDING);
    }

    public Ordering descending(javax.jcr.query.qom.DynamicOperand operand) {
        DynamicOperand jcrOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)operand, DynamicOperand.class, (String)"operand");
        return new Ordering(jcrOperand, Order.DESCENDING);
    }

    public javax.jcr.query.qom.And and(javax.jcr.query.qom.Constraint constraint1, javax.jcr.query.qom.Constraint constraint2) {
        Constraint jcrConstraint1 = (Constraint)CheckArg.getInstanceOf((Object)constraint1, Constraint.class, (String)"constraint1");
        Constraint jcrConstraint2 = (Constraint)CheckArg.getInstanceOf((Object)constraint2, Constraint.class, (String)"constraint2");
        return new And(jcrConstraint1, jcrConstraint2);
    }

    public BindVariableValue bindVariable(String bindVariableName) {
        CheckArg.isNotNull((Object)bindVariableName, (String)"bindVariableName");
        return new BindVariableName(bindVariableName);
    }

    public ChildNode childNode(String selectorName, String path) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)path, (String)"path");
        return new ChildNode(this.selectorName(selectorName), path);
    }

    public ChildNodeJoinCondition childNodeJoinCondition(String childSelectorName, String parentSelectorName) {
        CheckArg.isNotNull((Object)childSelectorName, (String)"childSelectorName");
        CheckArg.isNotNull((Object)parentSelectorName, (String)"parentSelectorName");
        return new ChildNodeJoinCondition(this.selectorName(parentSelectorName), this.selectorName(childSelectorName));
    }

    public Comparison comparison(javax.jcr.query.qom.DynamicOperand operand1, String operator, javax.jcr.query.qom.StaticOperand operand2) {
        DynamicOperand jcrOperand1 = (DynamicOperand)CheckArg.getInstanceOf((Object)operand1, DynamicOperand.class, (String)"operand1");
        CheckArg.isNotEmpty((String)operator, (String)"operator");
        StaticOperand jcrOperand2 = (StaticOperand)CheckArg.getInstanceOf((Object)operand2, StaticOperand.class, (String)"operand2");
        operator = operator.trim();
        Operator op = null;
        if ("jcr.operator.equal.to".equals(operator)) {
            op = Operator.EQUAL_TO;
        } else if ("jcr.operator.greater.than".equals(operator)) {
            op = Operator.GREATER_THAN;
        } else if ("jcr.operator.greater.than.or.equal.to".equals(operator)) {
            op = Operator.GREATER_THAN_OR_EQUAL_TO;
        } else if ("jcr.operator.less.than".equals(operator)) {
            op = Operator.LESS_THAN;
        } else if ("jcr.operator.less.than.or.equal.to".equals(operator)) {
            op = Operator.LESS_THAN_OR_EQUAL_TO;
        } else if ("jcr.operator.like".equals(operator)) {
            op = Operator.LIKE;
        } else if ("jcr.operator.not.equal.to".equals(operator)) {
            op = Operator.NOT_EQUAL_TO;
        }
        if (op == null) {
            throw new IllegalArgumentException("Unknown or unsupported comparison operator: " + operator);
        }
        return new Comparison(jcrOperand1, op, jcrOperand2);
    }

    public DescendantNode descendantNode(String selectorName, String path) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)path, (String)"path");
        return new DescendantNode(this.selectorName(selectorName), path);
    }

    public DescendantNodeJoinCondition descendantNodeJoinCondition(String descendantSelectorName, String ancestorSelectorName) {
        CheckArg.isNotNull((Object)descendantSelectorName, (String)"descendantSelectorName");
        CheckArg.isNotNull((Object)ancestorSelectorName, (String)"ancestorSelectorName");
        return new DescendantNodeJoinCondition(this.selectorName(ancestorSelectorName), this.selectorName(descendantSelectorName));
    }

    public EquiJoinCondition equiJoinCondition(String selector1Name, String property1Name, String selector2Name, String property2Name) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)property1Name, (String)"property1Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        CheckArg.isNotNull((Object)property2Name, (String)"property2Name");
        return new EquiJoinCondition(this.selectorName(selector1Name), property1Name, this.selectorName(selector2Name), property2Name);
    }

    public FullTextSearch fullTextSearch(String selectorName, String propertyName, javax.jcr.query.qom.StaticOperand fullTextSearchExpression) throws RepositoryException {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        StaticOperand expression = (StaticOperand)CheckArg.getInstanceOf((Object)fullTextSearchExpression, StaticOperand.class, (String)"fullTextSearchExpression");
        return new FullTextSearch(this.selectorName(selectorName), propertyName, expression, null);
    }

    public FullTextSearchScore fullTextSearchScore(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new FullTextSearchScore(this.selectorName(selectorName));
    }

    public Join join(javax.jcr.query.qom.Source left, javax.jcr.query.qom.Source right, String joinType, javax.jcr.query.qom.JoinCondition joinCondition) {
        Source leftSource = (Source)CheckArg.getInstanceOf((Object)left, Source.class, (String)"left");
        Source rightSource = (Source)CheckArg.getInstanceOf((Object)right, Source.class, (String)"right");
        JoinCondition jcrJoinCondition = (JoinCondition)CheckArg.getInstanceOf((Object)joinCondition, JoinCondition.class, (String)"joinCondition");
        CheckArg.isNotEmpty((String)joinType, (String)"joinType");
        joinType = joinType.trim();
        JoinType type = null;
        if ("jcr.join.type.cross".equals(joinType)) {
            type = JoinType.CROSS;
        } else if ("jcr.join.type.inner".equals(joinType)) {
            type = JoinType.INNER;
        } else if ("jcr.join.type.full.outer".equals(joinType)) {
            type = JoinType.FULL_OUTER;
        } else if ("jcr.join.type.left.outer".equals(joinType)) {
            type = JoinType.LEFT_OUTER;
        } else if ("jcr.join.type.right.outer".equals(joinType)) {
            type = JoinType.RIGHT_OUTER;
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown or unsupported join type: " + joinType);
        }
        return new Join(leftSource, type, rightSource, jcrJoinCondition);
    }

    public Length length(javax.jcr.query.qom.PropertyValue propertyValue) {
        PropertyValue jcrPropValue = (PropertyValue)CheckArg.getInstanceOf((Object)propertyValue, PropertyValue.class, (String)"propertyValue");
        return new Length(jcrPropValue);
    }

    public LiteralValue literal(Value literalValue) throws RepositoryException {
        CheckArg.isNotNull((Object)literalValue, (String)"literalValue");
        return new LiteralValue(literalValue);
    }

    public LowerCase lowerCase(javax.jcr.query.qom.DynamicOperand operand) {
        DynamicOperand jcrOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)operand, DynamicOperand.class, (String)"operand");
        return new LowerCase(jcrOperand);
    }

    public NodeLocalName nodeLocalName(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new NodeLocalName(this.selectorName(selectorName));
    }

    public NodeName nodeName(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new NodeName(this.selectorName(selectorName));
    }

    public Not not(javax.jcr.query.qom.Constraint constraint) {
        Constraint jcrConstraint = (Constraint)CheckArg.getInstanceOf((Object)constraint, Constraint.class, (String)"constraint");
        return new Not(jcrConstraint);
    }

    public Or or(javax.jcr.query.qom.Constraint constraint1, javax.jcr.query.qom.Constraint constraint2) {
        Constraint jcrConstraint1 = (Constraint)CheckArg.getInstanceOf((Object)constraint1, Constraint.class, (String)"constraint1");
        Constraint jcrConstraint2 = (Constraint)CheckArg.getInstanceOf((Object)constraint2, Constraint.class, (String)"constraint2");
        return new Or(jcrConstraint1, jcrConstraint2);
    }

    public PropertyExistence propertyExistence(String selectorName, String propertyName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        return new PropertyExistence(this.selectorName(selectorName), propertyName);
    }

    public PropertyValue propertyValue(String selectorName, String propertyName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        return new PropertyValue(this.selectorName(selectorName), propertyName);
    }

    public SameNode sameNode(String selectorName, String path) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)path, (String)"path");
        return new SameNode(this.selectorName(selectorName), path);
    }

    public SameNodeJoinCondition sameNodeJoinCondition(String selector1Name, String selector2Name, String selector2Path) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        return new SameNodeJoinCondition(this.selectorName(selector1Name), this.selectorName(selector2Name), selector2Path);
    }

    public UpperCase upperCase(javax.jcr.query.qom.DynamicOperand operand) {
        DynamicOperand jcrOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)operand, DynamicOperand.class, (String)"operand");
        return new UpperCase(jcrOperand);
    }

    public NodePath nodePath(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new NodePath(this.selectorName(selectorName));
    }

    public NodeDepth nodeDepth(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new NodeDepth(this.selectorName(selectorName));
    }

    public Limit limit(int rowLimit, int offset) {
        CheckArg.isPositive((int)rowLimit, (String)"rowLimit");
        CheckArg.isNonNegative((int)offset, (String)"offset");
        return new Limit(rowLimit, offset);
    }

    public Between between(javax.jcr.query.qom.DynamicOperand operand, javax.jcr.query.qom.StaticOperand lowerBound, javax.jcr.query.qom.StaticOperand upperBound, boolean includeLowerBound, boolean includeUpperBound) {
        DynamicOperand jcrOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)operand, DynamicOperand.class, (String)"operand");
        StaticOperand lower = (StaticOperand)CheckArg.getInstanceOf((Object)lowerBound, StaticOperand.class, (String)"lowerBound");
        StaticOperand upper = (StaticOperand)CheckArg.getInstanceOf((Object)upperBound, StaticOperand.class, (String)"upperBound");
        return new Between(jcrOperand, lower, upper, includeLowerBound, includeUpperBound);
    }

    public SetCriteria in(javax.jcr.query.qom.DynamicOperand operand, javax.jcr.query.qom.StaticOperand ... values) {
        DynamicOperand jcrOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)operand, DynamicOperand.class, (String)"operand");
        ArrayList<StaticOperand> jcrValues = new ArrayList<StaticOperand>();
        for (javax.jcr.query.qom.StaticOperand value : values) {
            StaticOperand jcrValue = (StaticOperand)CheckArg.getInstanceOf((Object)value, StaticOperand.class, (String)"values");
            jcrValues.add(jcrValue);
        }
        return new SetCriteria(jcrOperand, jcrValues);
    }

    public Subquery subquery(org.modeshape.jcr.api.query.qom.QueryCommand subqueryCommand) {
        QueryCommand jcrCommand = (QueryCommand)CheckArg.getInstanceOf((Object)subqueryCommand, QueryCommand.class, (String)"subqueryCommand");
        return new Subquery(jcrCommand);
    }

    public ArithmeticOperand add(javax.jcr.query.qom.DynamicOperand left, javax.jcr.query.qom.DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.ADD, right);
    }

    public ArithmeticOperand subtract(javax.jcr.query.qom.DynamicOperand left, javax.jcr.query.qom.DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.SUBTRACT, right);
    }

    public ArithmeticOperand multiply(javax.jcr.query.qom.DynamicOperand left, javax.jcr.query.qom.DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.MULTIPLY, right);
    }

    public ArithmeticOperand divide(javax.jcr.query.qom.DynamicOperand left, javax.jcr.query.qom.DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.DIVIDE, right);
    }

    public ArithmeticOperand arithmeticOperand(javax.jcr.query.qom.DynamicOperand left, ArithmeticOperator operator, javax.jcr.query.qom.DynamicOperand right) {
        DynamicOperand leftOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)left, DynamicOperand.class, (String)"left");
        DynamicOperand rightOperand = (DynamicOperand)CheckArg.getInstanceOf((Object)left, DynamicOperand.class, (String)"left");
        return new ArithmeticOperand(leftOperand, operator, rightOperand);
    }

    public ReferenceValue referenceValue(String selectorName) {
        return new ReferenceValue(this.selectorName(selectorName), null);
    }

    public ReferenceValue referenceValue(String selectorName, String propertyName) {
        return new ReferenceValue(this.selectorName(selectorName), propertyName);
    }
}

