/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.basic.SimpleNamespaceRegistry;

@ThreadSafe
public class ThreadSafeNamespaceRegistry
implements NamespaceRegistry {
    private final ReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final NamespaceRegistry delegate;

    public ThreadSafeNamespaceRegistry() {
        this(new SimpleNamespaceRegistry());
    }

    public ThreadSafeNamespaceRegistry(NamespaceRegistry nonThreadSafeRegistry) {
        CheckArg.isNotNull((Object)nonThreadSafeRegistry, (String)"nonThreadSafeRegistry");
        this.delegate = nonThreadSafeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceForPrefix(String prefix) {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.delegate.getNamespaceForPrefix(prefix);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String prefix = null;
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            prefix = this.delegate.getPrefixForNamespaceUri(namespaceUri, false);
        }
        finally {
            lock.unlock();
        }
        if (prefix == null && generateIfMissing) {
            lock = this.registryLock.writeLock();
            try {
                lock.lock();
                String string = prefix = this.delegate.getPrefixForNamespaceUri(namespaceUri, true);
                return string;
            }
            finally {
                lock.unlock();
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            boolean bl = this.delegate.isRegisteredNamespaceUri(namespaceUri);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultNamespaceUri() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.delegate.getDefaultNamespaceUri();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Iterable<NamespaceRegistry.Namespace> namespaces) {
        CheckArg.isNotNull(namespaces, (String)"namespaces");
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            for (NamespaceRegistry.Namespace namespace : namespaces) {
                this.register(namespace.getPrefix(), namespace.getNamespaceUri());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            String string = this.delegate.register(prefix, namespaceUri);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            boolean bl = this.delegate.unregister(namespaceUri);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredNamespaceUris() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            Set<String> set = this.delegate.getRegisteredNamespaceUris();
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            Set<NamespaceRegistry.Namespace> set = this.delegate.getNamespaces();
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        ArrayList<NamespaceRegistry.Namespace> namespaces = new ArrayList<NamespaceRegistry.Namespace>(this.getNamespaces());
        Collections.sort(namespaces);
        return ((Object)namespaces).toString();
    }
}

