/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.observation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.observation.NodeChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeChanges
implements Iterable<NodeChange> {
    protected static final Comparator<NodeChange> PRE_ORDER = new Comparator<NodeChange>(){

        @Override
        public int compare(NodeChange change1, NodeChange change2) {
            return change1.getAbsolutePath().compareTo(change2.getAbsolutePath());
        }
    };
    private final List<NodeChange> changesInPreOrder;

    public static NodeChanges create(String repositoryWorkspaceName, Iterable<Event> events) throws RepositoryException {
        HashMap<String, NodeChangeDetails> detailsByNodePath = new HashMap<String, NodeChangeDetails>();
        for (Event event : events) {
            NodeChangeDetails details;
            int eventType = event.getType();
            String eventPath = event.getPath();
            if (eventType == 4 || eventType == 16 || eventType == 8) {
                int lastDelim = eventPath.lastIndexOf(47);
                if (lastDelim < 1 || lastDelim == eventPath.length() - 1) {
                    I18n msg = eventType == 4 ? RepositoryI18n.errorFindingPropertyNameInPropertyAddedEvent : (eventType == 16 ? RepositoryI18n.errorFindingPropertyNameInPropertyChangedEvent : RepositoryI18n.errorFindingPropertyNameInPropertyRemovedEvent);
                    Logger.getLogger(NodeChanges.class).error(msg, new Object[]{eventPath});
                    continue;
                }
                String nodePath = eventPath.substring(0, lastDelim);
                String propertyName = eventPath.substring(lastDelim + 1);
                NodeChangeDetails details2 = (NodeChangeDetails)detailsByNodePath.get(nodePath);
                if (details2 == null) {
                    details2 = new NodeChangeDetails(nodePath);
                    detailsByNodePath.put(nodePath, details2);
                }
                switch (eventType) {
                    case 4: {
                        details2.addProperty(propertyName);
                        break;
                    }
                    case 16: {
                        details2.changeProperty(propertyName);
                        break;
                    }
                    case 8: {
                        details2.removeProperty(propertyName);
                    }
                }
                continue;
            }
            if (eventType != 1 && eventType != 2) continue;
            String nodePath = eventPath;
            if (nodePath.length() > 1 && nodePath.charAt(nodePath.length() - 1) == '/') {
                nodePath = nodePath.substring(0, nodePath.length() - 1);
            }
            if ((details = (NodeChangeDetails)detailsByNodePath.get(nodePath)) == null) {
                details = new NodeChangeDetails(nodePath);
                detailsByNodePath.put(nodePath, details);
            }
            details.addEventType(eventType);
        }
        ArrayList<NodeChange> result = new ArrayList<NodeChange>(detailsByNodePath.size());
        for (NodeChangeDetails detail : detailsByNodePath.values()) {
            NodeChange change = new NodeChange(repositoryWorkspaceName, detail.getNodePath(), detail.getEventTypes(), detail.getModifiedProperties(), detail.getRemovedProperties());
            result.add(change);
        }
        return new NodeChanges(result);
    }

    protected NodeChanges(List<NodeChange> changes) {
        this.changesInPreOrder = Collections.unmodifiableList(changes);
    }

    @Override
    public Iterator<NodeChange> iterator() {
        return this.changesInPreOrder.iterator();
    }

    public Iterator<NodeChange> getPreOrder() {
        return this.changesInPreOrder.iterator();
    }

    public int size() {
        return this.changesInPreOrder.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NodeChangeDetails {
        private final String nodePath;
        private final Set<String> modifiedProperties = new HashSet<String>();
        private final Set<String> removedProperties = new HashSet<String>();
        private int eventTypes;

        protected NodeChangeDetails(String nodePath) {
            this.nodePath = nodePath;
        }

        public void addEventType(int eventType) {
            this.eventTypes |= eventType;
        }

        public void addProperty(String propertyName) {
            this.modifiedProperties.add(propertyName);
            this.eventTypes |= 4;
        }

        public void changeProperty(String propertyName) {
            this.modifiedProperties.add(propertyName);
            this.eventTypes |= 0x10;
        }

        public void removeProperty(String propertyName) {
            this.removedProperties.add(propertyName);
            this.eventTypes |= 8;
        }

        public int getEventTypes() {
            return this.eventTypes;
        }

        public String getNodePath() {
            return this.nodePath;
        }

        public Set<String> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<String> getRemovedProperties() {
            return this.removedProperties;
        }
    }
}

