/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.schematic.internal.schema.DocumentTransformer;
import org.infinispan.schematic.internal.schema.SchemaDocument;
import org.infinispan.schematic.internal.schema.SchemaDocumentCache;
import org.infinispan.schematic.internal.schema.ValidationResult;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;

public class CacheSchemaLibrary
implements SchemaLibrary,
Lifecycle {
    private final String name;
    private final Cache<String, SchematicEntry> store;
    private final String defaultContentType;
    private final SchemaDocumentCache schemaDocuments;
    private final SchemaListener listener;

    public CacheSchemaLibrary(Cache<String, SchematicEntry> schemaStore) {
        this.name = schemaStore.getName();
        this.store = schemaStore;
        this.defaultContentType = "application/schema+json";
        this.schemaDocuments = new SchemaDocumentCache(this, null);
        this.listener = new SchemaListener(this.schemaDocuments);
        this.store.addListener((Object)this.listener);
    }

    public void start() {
        this.store.start();
    }

    public void stop() {
        this.store.removeListener((Object)this.listener);
        this.store.stop();
    }

    protected Cache<String, SchematicEntry> store() {
        return this.store;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document get(String key) {
        return this.document((SchematicEntry)this.store.get((Object)key));
    }

    @Override
    public Document put(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document, null, this.defaultContentType);
        return this.document((SchematicEntry)this.store.put((Object)key, (Object)newEntry));
    }

    @Override
    public Document putIfAbsent(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document, null, this.defaultContentType);
        return this.document((SchematicEntry)this.store.putIfAbsent((Object)key, (Object)newEntry));
    }

    @Override
    public Document replace(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document, null, this.defaultContentType);
        return this.document((SchematicEntry)this.store.replace((Object)key, (Object)newEntry));
    }

    @Override
    public Document remove(String key) {
        return this.document((SchematicEntry)this.store.remove((Object)key));
    }

    @Override
    public NotifyingFuture<Document> getAsync(String key) {
        return this.future((NotifyingFuture<SchematicEntry>)this.store.getAsync((Object)key));
    }

    @Override
    public NotifyingFuture<Document> putAsync(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document, null, this.defaultContentType);
        return this.future((NotifyingFuture<SchematicEntry>)this.store.putAsync((Object)key, (Object)newEntry));
    }

    @Override
    public NotifyingFuture<Document> putIfAbsentAsync(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document, null, this.defaultContentType);
        return this.future((NotifyingFuture<SchematicEntry>)this.store.putIfAbsentAsync((Object)key, (Object)newEntry));
    }

    @Override
    public NotifyingFuture<Document> replaceAsync(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document, null, this.defaultContentType);
        return this.future((NotifyingFuture<SchematicEntry>)this.store.replaceAsync((Object)key, (Object)newEntry));
    }

    @Override
    public NotifyingFuture<Document> removeAsync(String key) {
        return this.future((NotifyingFuture<SchematicEntry>)this.store.removeAsync((Object)key));
    }

    @Override
    public SchemaLibrary.Results validate(Document document, String schemaUri) {
        ValidationResult result = new ValidationResult();
        SchemaDocument schema = this.schemaDocuments.get(schemaUri, result);
        if (schema != null) {
            schema.getValidator().validate(null, null, document, Paths.rootPath(), result, this.schemaDocuments);
        }
        return result;
    }

    @Override
    public Document convertValues(Document document, SchemaLibrary.Results results) {
        return DocumentTransformer.convertValuesWithMismatchedTypes(document, results);
    }

    @Override
    public Document convertValues(Document document, String schemaUri) {
        SchemaLibrary.Results results = this.validate(document, schemaUri);
        return this.convertValues(document, results);
    }

    protected Document document(SchematicEntry entry) {
        return entry != null ? entry.getContentAsDocument() : null;
    }

    protected NotifyingFuture<Document> future(NotifyingFuture<SchematicEntry> original) {
        return new WrappedFuture(original);
    }

    @Listener
    public class SchemaListener {
        private final SchemaDocumentCache cachedSchemas;

        protected SchemaListener(SchemaDocumentCache cachedSchemas) {
            this.cachedSchemas = cachedSchemas;
        }

        @CacheEntryModified
        public void schemaChanged(CacheEntryModifiedEvent<String, SchematicEntry> event) {
            String key = (String)event.getKey();
            this.cachedSchemas.remove(key);
        }

        @CacheEntryRemoved
        public void schemaChanged(CacheEntryRemovedEvent<String, SchematicEntry> event) {
            String key = (String)event.getKey();
            this.cachedSchemas.remove(key);
        }
    }

    protected class WrappedFuture
    implements NotifyingFuture<Document> {
        private final NotifyingFuture<SchematicEntry> original;

        protected WrappedFuture(NotifyingFuture<SchematicEntry> original) {
            this.original = original;
        }

        public NotifyingFuture<Document> attachListener(final FutureListener<Document> listener) {
            this.original.attachListener((FutureListener)new FutureListener<SchematicEntry>(){

                public void futureDone(Future<SchematicEntry> future) {
                    listener.futureDone((Future)((Object)WrappedFuture.this));
                }
            });
            return this;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.original.cancel(mayInterruptIfRunning);
        }

        public Document get() throws InterruptedException, ExecutionException {
            SchematicEntry result = (SchematicEntry)this.original.get();
            return result != null ? result.getContentAsDocument() : null;
        }

        public Document get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            SchematicEntry result = (SchematicEntry)this.original.get(timeout, unit);
            return result != null ? result.getContentAsDocument() : null;
        }

        public boolean isCancelled() {
            return this.original.isCancelled();
        }

        public boolean isDone() {
            return this.original.isDone();
        }
    }
}

