/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;

public class JcrBinary
implements Binary {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int MAX_BUFFER_SIZE = 65536;
    private final File tmpFile;
    private byte[] buffer = EMPTY_BYTE_ARRAY;
    public static final Binary EMPTY = new JcrBinary(EMPTY_BYTE_ARRAY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrBinary(InputStream in) throws IOException {
        byte[] spoolBuffer = new byte[8192];
        int len = 0;
        OutputStream out = null;
        File spoolFile = null;
        try {
            int read;
            while ((read = in.read(spoolBuffer)) > 0) {
                if (out != null) {
                    out.write(spoolBuffer, 0, read);
                    len += read;
                    continue;
                }
                if (len + read > 65536) {
                    spoolFile = File.createTempFile("bin", null, null);
                    out = new FileOutputStream(spoolFile);
                    out.write(this.buffer, 0, len);
                    out.write(spoolBuffer, 0, read);
                    this.buffer = null;
                    len += read;
                    continue;
                }
                byte[] newBuffer = new byte[len + read];
                System.arraycopy(this.buffer, 0, newBuffer, 0, len);
                System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                this.buffer = newBuffer;
                len += read;
            }
        }
        finally {
            in.close();
            if (out != null) {
                out.close();
            }
        }
        this.tmpFile = spoolFile;
    }

    public JcrBinary(byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must be non-null");
        }
        this.buffer = buffer;
        this.tmpFile = null;
    }

    public InputStream getStream() throws RepositoryException {
        if (this.tmpFile != null) {
            try {
                return new FileInputStream(this.tmpFile);
            }
            catch (FileNotFoundException e) {
                throw new RepositoryException("already disposed");
            }
        }
        return new ByteArrayInputStream(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, long position) throws IOException, RepositoryException {
        if (this.tmpFile != null) {
            RandomAccessFile raf = new RandomAccessFile(this.tmpFile, "r");
            try {
                raf.seek(position);
                int n = raf.read(b);
                return n;
            }
            finally {
                raf.close();
            }
        }
        int length = Math.min(b.length, this.buffer.length - (int)position);
        if (length > 0) {
            System.arraycopy(this.buffer, (int)position, b, 0, length);
            return length;
        }
        return -1;
    }

    public long getSize() throws RepositoryException {
        if (this.tmpFile != null) {
            return this.tmpFile.exists() ? this.tmpFile.length() : -1L;
        }
        return this.buffer.length;
    }

    public void dispose() {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
        } else {
            this.buffer = EMPTY_BYTE_ARRAY;
        }
    }
}

