/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.List;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="topologyaware.TopologyAwareStateTransferTest")
@CleanupAfterTest
public class TopologyAwareStateTransferTest
extends MultipleCacheManagersTest {
    private Address[] addresses;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration defaultConfig = TopologyAwareStateTransferTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
        this.log.debug((Object)("defaultConfig = " + defaultConfig.getNumOwners()));
        defaultConfig.setL1CacheEnabled(false);
        this.createClusteredCaches(5, defaultConfig);
        TopologyAwareConsistentHash hash = (TopologyAwareConsistentHash)this.cache(0).getAdvancedCache().getDistributionManager().getConsistentHash();
        Set addressSet = hash.getCaches();
        this.addresses = addressSet.toArray(new Address[addressSet.size()]);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    Cache cache(Address addr) {
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getRpcManager().getAddress().equals(addr)) continue;
            return c;
        }
        throw new RuntimeException("Address: " + addr);
    }

    public void testInitialState() {
        this.cache(0).put((Object)this.addresses[0], (Object)"v0");
        this.cache(0).put((Object)this.addresses[1], (Object)"v1");
        this.cache(0).put((Object)this.addresses[2], (Object)"v2");
        this.cache(0).put((Object)this.addresses[3], (Object)"v3");
        this.cache(0).put((Object)this.addresses[4], (Object)"v4");
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[1], (Object)TestingUtil.printCache(this.cache(this.addresses[1])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[2], (Object)TestingUtil.printCache(this.cache(this.addresses[2])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
    }

    @Test(dependsOnMethods={"testInitialState"})
    public void testNodeDown() {
        EmbeddedCacheManager cm = this.cache(this.addresses[4]).getCacheManager();
        this.log.info((Object)"Here is where ST starts");
        TestingUtil.killCacheManagers(cm);
        this.cacheManagers.remove(cm);
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches());
        TestingUtil.waitForRehashToComplete(this.caches());
        this.log.info((Object)"Here is where ST ends");
        Set addressList = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getConsistentHash().getCaches();
        this.log.debug((Object)("After shutting down " + this.addresses[4] + " caches are " + addressList));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[1], (Object)TestingUtil.printCache(this.cache(this.addresses[1])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[2], (Object)TestingUtil.printCache(this.cache(this.addresses[2])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
    }

    @Test(dependsOnMethods={"testNodeDown"})
    public void testNodeDown2() {
        EmbeddedCacheManager cm = this.cache(this.addresses[2]).getCacheManager();
        TestingUtil.killCacheManagers(cm);
        this.cacheManagers.remove(cm);
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches());
        TestingUtil.waitForRehashToComplete(this.caches());
        Set addressList = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getConsistentHash().getCaches();
        this.log.debug((Object)("After shutting down " + this.addresses[2] + " caches are " + addressList));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[1], (Object)TestingUtil.printCache(this.cache(this.addresses[1])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
    }

    @Test(dependsOnMethods={"testNodeDown2"})
    public void testNodeDown3() {
        EmbeddedCacheManager cm = this.cache(this.addresses[1]).getCacheManager();
        TestingUtil.killCacheManagers(cm);
        this.cacheManagers.remove(cm);
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches());
        TestingUtil.waitForRehashToComplete(this.caches());
        Set addressList = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getConsistentHash().getCaches();
        this.log.debug((Object)("After shutting down " + this.addresses[1] + " caches are " + addressList));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[0], (Object)TestingUtil.printCache(this.cache(this.addresses[0])));
        this.log.debugf("Cache on node %s: %s", (Object)this.addresses[3], (Object)TestingUtil.printCache(this.cache(this.addresses[3])));
        this.assertExistence(this.addresses[0]);
        this.assertExistence(this.addresses[1]);
        this.assertExistence(this.addresses[2]);
        this.assertExistence(this.addresses[3]);
        this.assertExistence(this.addresses[4]);
    }

    private void assertExistence(Object key) {
        ConsistentHash hash = this.cache(this.addresses[0]).getAdvancedCache().getDistributionManager().getConsistentHash();
        List addresses = hash.locate(key, 2);
        this.log.debug((Object)(key + " should be present on = " + addresses));
        int count = 0;
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getDataContainer().containsKey(key)) continue;
            this.log.debug((Object)("It is here = " + this.address(c)));
            ++count;
        }
        this.log.debug((Object)("count = " + count));
        assert (count == 2);
        for (Cache c : this.caches()) {
            if (addresses.contains(this.address(c)) ? !$assertionsDisabled && !c.getAdvancedCache().getDataContainer().containsKey(key) : !$assertionsDisabled && c.getAdvancedCache().getDataContainer().containsKey(key)) {
                throw new AssertionError();
            }
        }
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(Configuration deConfiguration) {
        String machine;
        String rack;
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(deConfiguration);
        int index = this.cacheManagers.size();
        switch (index) {
            case 0: {
                rack = "r0";
                machine = "m0";
                break;
            }
            case 1: {
                rack = "r0";
                machine = "m1";
                break;
            }
            case 2: {
                rack = "r1";
                machine = "m0";
                break;
            }
            case 3: {
                rack = "r2";
                machine = "m0";
                break;
            }
            case 4: {
                rack = "r2";
                machine = "m0";
                break;
            }
            default: {
                throw new RuntimeException("Bad!");
            }
        }
        GlobalConfiguration globalConfiguration = cm.getGlobalConfiguration();
        globalConfiguration.setRackId(rack);
        globalConfiguration.setMachineId(machine);
        this.cacheManagers.add(cm);
        return cm;
    }
}

