/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.virtualnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.TestTopologyAwareAddress;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="topologyaware.VNodesTopologyAwareConsistentHashTest")
public class VNodesTopologyAwareConsistentHashTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(VNodesTopologyAwareConsistentHashTest.class);
    protected TopologyAwareConsistentHash ch;
    protected HashSet<Address> addresses;
    TestTopologyAwareAddress[] testAddresses;

    @BeforeMethod
    public void setUp() {
        this.ch = new TopologyAwareConsistentHash((Hash)new MurmurHash3());
        this.addresses = new HashSet();
        for (int i = 0; i < 10; ++i) {
            this.addresses.add(new TestTopologyAwareAddress(i * 100));
        }
        this.ch.setCaches(this.addresses);
        Set tmp = this.ch.getCaches();
        int i = 0;
        this.testAddresses = new TestTopologyAwareAddress[tmp.size()];
        for (Address a : tmp) {
            this.testAddresses[i++] = (TestTopologyAwareAddress)a;
        }
        this.ch = new TopologyAwareConsistentHash((Hash)new MurmurHash3());
        this.ch.setNumVirtualNodes(Integer.valueOf(10));
        this.addresses.clear();
    }

    public void testNumberOfOwners() {
        int i;
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.setAddresses();
        assert (this.ch.locate((Object)this.testAddresses[0], 1).size() == 1);
        assert (this.ch.locate((Object)this.testAddresses[0], 2).size() == 1);
        this.addNode(this.testAddresses[1], "m1", null, null);
        this.setAddresses();
        for (i = 0; i < this.testAddresses.length; ++i) {
            assert (this.ch.locate((Object)this.testAddresses[i], 1).size() == 1);
            assert (this.ch.locate((Object)this.testAddresses[i], 2).size() == 2);
            assert (this.ch.locate((Object)this.testAddresses[i], 3).size() == 2);
        }
        this.addNode(this.testAddresses[2], "m2", null, null);
        this.setAddresses();
        for (i = 0; i < this.testAddresses.length; ++i) {
            assert (this.ch.locate((Object)this.testAddresses[i], 1).size() == 1);
            assert (this.ch.locate((Object)this.testAddresses[i], 2).size() == 2);
            assert (this.ch.locate((Object)this.testAddresses[i], 3).size() == 3);
            assert (this.ch.locate((Object)this.testAddresses[i], 4).size() == 3);
        }
    }

    public void testAllDifferentMachines() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.addNode(this.testAddresses[i], "m" + i, null, null);
        }
        this.setAddresses();
        for (i = 0; i < this.testAddresses.length; ++i) {
            List owners = this.ch.locate((Object)this.testAddresses[i], 2);
            assert (!((TopologyAwareAddress)owners.get(0)).getMachineId().equals(((TopologyAwareAddress)owners.get(1)).getMachineId()));
            owners = this.ch.locate((Object)this.testAddresses[i], 20);
            Assert.assertEquals((int)owners.size(), (int)10);
            HashSet<String> machineIds = new HashSet<String>();
            for (Address owner : owners) {
                machineIds.add(((TopologyAwareAddress)owner).getMachineId());
            }
            Assert.assertEquals((int)machineIds.size(), (int)10);
        }
    }

    public void testDifferentRacks() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.addNode(this.testAddresses[i], "m" + i, "r" + i / 2, null);
        }
        this.setAddresses();
        for (i = 0; i < this.testAddresses.length; ++i) {
            List owners = this.ch.locate((Object)this.testAddresses[i], 2);
            assert (!((TopologyAwareAddress)owners.get(0)).getRackId().equals(((TopologyAwareAddress)owners.get(1)).getRackId()));
            owners = this.ch.locate((Object)this.testAddresses[i], 20);
            Assert.assertEquals((int)owners.size(), (int)10);
            HashSet<String> machineIds = new HashSet<String>();
            for (Address owner : owners) {
                machineIds.add(((TopologyAwareAddress)owner).getMachineId());
            }
            Assert.assertEquals((int)machineIds.size(), (int)10);
            HashSet<String> rackIds = new HashSet<String>();
            for (Address owner : owners) {
                rackIds.add(((TopologyAwareAddress)owner).getRackId());
            }
            Assert.assertEquals((int)rackIds.size(), (int)5);
        }
    }

    public void testDifferentSites() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.addNode(this.testAddresses[i], "m" + i, "r" + i / 2, "s" + i / 5);
        }
        this.setAddresses();
        for (i = 0; i < this.testAddresses.length; ++i) {
            List owners = this.ch.locate((Object)this.testAddresses[i], 2);
            assert (!((TopologyAwareAddress)owners.get(0)).getSiteId().equals(((TopologyAwareAddress)owners.get(1)).getSiteId()));
            owners = this.ch.locate((Object)this.testAddresses[i], 20);
            Assert.assertEquals((int)owners.size(), (int)10);
            HashSet<String> machineIds = new HashSet<String>();
            for (Address owner : owners) {
                machineIds.add(((TopologyAwareAddress)owner).getMachineId());
            }
            Assert.assertEquals((int)machineIds.size(), (int)10);
            HashSet<String> rackIds = new HashSet<String>();
            for (Address owner : owners) {
                rackIds.add(((TopologyAwareAddress)owner).getRackId());
            }
            Assert.assertEquals((int)rackIds.size(), (int)5);
            HashSet<String> siteIds = new HashSet<String>();
            for (Address owner : owners) {
                siteIds.add(((TopologyAwareAddress)owner).getSiteId());
            }
            Assert.assertEquals((int)siteIds.size(), (int)2);
        }
    }

    public void testConsistencyWhenNodeLeaves() {
        this.addNode(this.testAddresses[0], "m2", "r0", "s1");
        this.addNode(this.testAddresses[1], "m1", "r0", "s0");
        this.addNode(this.testAddresses[2], "m1", "r0", "s1");
        this.addNode(this.testAddresses[3], "m1", "r1", "s0");
        this.addNode(this.testAddresses[4], "m0", "r0", "s1");
        this.addNode(this.testAddresses[5], "m0", "r1", "s1");
        this.addNode(this.testAddresses[6], "m0", "r1", "s0");
        this.addNode(this.testAddresses[7], "m0", "r0", "s3");
        this.addNode(this.testAddresses[8], "m0", "r0", "s2");
        this.addNode(this.testAddresses[9], "m0", "r0", "s0");
        this.setAddresses();
        List testAddresses0List = this.ch.locate((Object)this.testAddresses[0], 3);
        List testAddresses1List = this.ch.locate((Object)this.testAddresses[1], 3);
        List testAddresses2List = this.ch.locate((Object)this.testAddresses[2], 3);
        List testAddresses3List = this.ch.locate((Object)this.testAddresses[3], 3);
        List testAddresses4List = this.ch.locate((Object)this.testAddresses[4], 3);
        List testAddresses5List = this.ch.locate((Object)this.testAddresses[5], 3);
        List testAddresses6List = this.ch.locate((Object)this.testAddresses[6], 3);
        List testAddresses7List = this.ch.locate((Object)this.testAddresses[7], 3);
        List testAddresses8List = this.ch.locate((Object)this.testAddresses[8], 3);
        List testAddresses9List = this.ch.locate((Object)this.testAddresses[9], 3);
        for (Address addr : this.addresses) {
            System.out.println("addr = " + addr);
            Set addressCopy = (Set)this.addresses.clone();
            addressCopy.remove(addr);
            this.ch.setCaches(addressCopy);
            this.checkConsistency(testAddresses0List, this.testAddresses[0], addr, 3);
            this.checkConsistency(testAddresses1List, this.testAddresses[1], addr, 3);
            this.checkConsistency(testAddresses2List, this.testAddresses[2], addr, 3);
            this.checkConsistency(testAddresses3List, this.testAddresses[3], addr, 3);
            this.checkConsistency(testAddresses4List, this.testAddresses[4], addr, 3);
            this.checkConsistency(testAddresses5List, this.testAddresses[5], addr, 3);
            this.checkConsistency(testAddresses6List, this.testAddresses[6], addr, 3);
            this.checkConsistency(testAddresses7List, this.testAddresses[7], addr, 3);
            this.checkConsistency(testAddresses8List, this.testAddresses[8], addr, 3);
            this.checkConsistency(testAddresses9List, this.testAddresses[9], addr, 3);
        }
    }

    private void checkConsistency(List<Address> testAddressesList, Address testAddresses, Address addr, int replCount) {
        testAddressesList = new ArrayList<Address>(testAddressesList);
        testAddressesList.remove(addr);
        if (testAddresses.equals(addr)) {
            return;
        }
        List currentBackupList = this.ch.locate((Object)testAddresses, replCount);
        Assert.assertEquals((int)replCount, (int)currentBackupList.size(), (String)currentBackupList.toString());
        assert (currentBackupList.containsAll(testAddressesList)) : "Current backups are: " + currentBackupList + "Previous: " + testAddressesList;
    }

    private void assertLocation(Object key, int numOwners, boolean enforceSequence, Address ... expected) {
        List received = this.ch.locate(key, numOwners);
        if (expected == null) assert (received.isEmpty());
        Assert.assertEquals((int)received.size(), (int)expected.length);
        if (enforceSequence ? !$assertionsDisabled && !((Object)received).equals(Arrays.asList(expected)) : !$assertionsDisabled && !received.containsAll(Arrays.asList(expected))) {
            throw new AssertionError((Object)("Received: " + received + " Expected: " + Arrays.toString(expected)));
        }
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            boolean shouldBeLocal = received.contains(testAddress);
            boolean isLocal = this.ch.isKeyLocalToAddress((Address)testAddress, key, numOwners);
            Assert.assertEquals((boolean)isLocal, (boolean)shouldBeLocal);
        }
    }

    private void addNode(TestTopologyAwareAddress address, String machineId, String rackId, String siteId) {
        this.addresses.add(address);
        address.setSiteId(siteId);
        address.setRackId(rackId);
        address.setMachineId(machineId);
    }

    private void setAddresses() {
        this.ch.setCaches(this.addresses);
        for (int i = 0; i < this.testAddresses.length; ++i) {
            if (this.testAddresses[i] == null) continue;
            this.testAddresses[i].setName("a" + i);
        }
        log.info((Object)("Static addresses: " + Arrays.toString(this.testAddresses)));
    }
}

